/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCompressedIronBlock
extends TileEntityTickableBase
implements IComparatorSupport,
IHeatTinted {
    protected final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private int comparatorOutput = 0;
    @DescSynced
    private final SyncedTemperature syncedTemperature = new SyncedTemperature();

    public TileEntityCompressedIronBlock() {
        this((TileEntityType)ModTileEntities.COMPRESSED_IRON_BLOCK.get());
    }

    TileEntityCompressedIronBlock(TileEntityType type) {
        super(type);
        this.heatExchanger.setThermalCapacity(10.0);
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            this.syncedTemperature.setCurrentTemp(this.heatExchanger.getTemperature());
            int newComparatorOutput = HeatUtil.getComparatorOutput((int)this.heatExchanger.getTemperature());
            if (this.comparatorOutput != newComparatorOutput) {
                this.comparatorOutput = newComparatorOutput;
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public int getComparatorValue() {
        return this.comparatorOutput;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return HeatUtil.getColourForTemperature(this.syncedTemperature.getSyncedTemp());
    }
}

