/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PneumaticProvider {

    public static class Component
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            CompoundNBT tag = accessor.getServerData();
            TileEntity te = accessor.getTileEntity();
            if (te instanceof IInfoForwarder) {
                BlockPos infoPos = new BlockPos(tag.func_74762_e("infoX"), tag.func_74762_e("infoY"), tag.func_74762_e("infoZ"));
                te = accessor.getWorld().func_175625_s(infoPos);
            }
            if (te != null) {
                te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> {
                    if (h instanceof MachineAirHandler) {
                        this.addTipToMachine(tooltip, (MachineAirHandler)h, tag.func_74760_g("pressure"));
                    }
                });
                this.handleHeatData(tooltip, tag);
            }
        }

        private void handleHeatData(List<ITextComponent> tooltip, CompoundNBT tag) {
            if (tag.func_74764_b("heatData")) {
                TemperatureData tempData = TemperatureData.fromNBT(tag.func_74775_l("heatData"));
                if (tempData.isMultisided()) {
                    for (Direction face : Direction.field_199792_n) {
                        if (!tempData.hasData(face)) continue;
                        tooltip.add(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
                    }
                } else if (tempData.hasData(null)) {
                    tooltip.add(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
                }
            }
        }

        private void addTipToMachine(List<ITextComponent> tooltip, MachineAirHandler airHandler, float pressure) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(pressure, 1));
            values.put("gui.tooltip.maxPressure", PneumaticCraftUtils.roundNumberTo(airHandler.getDangerPressure(), 1));
            for (Map.Entry entry : values.entrySet()) {
                tooltip.add((ITextComponent)new TranslationTextComponent((String)entry.getKey(), new Object[]{entry.getValue()}));
            }
        }
    }

    public static class Data
    implements IServerDataProvider<TileEntity> {
        public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, TileEntity te) {
            TileEntity teInfo;
            if (te instanceof IInfoForwarder) {
                teInfo = ((IInfoForwarder)te).getInfoTileEntity();
                if (teInfo != null) {
                    compoundNBT.func_74768_a("infoX", teInfo.func_174877_v().func_177958_n());
                    compoundNBT.func_74768_a("infoY", teInfo.func_174877_v().func_177956_o());
                    compoundNBT.func_74768_a("infoZ", teInfo.func_174877_v().func_177952_p());
                }
            } else {
                teInfo = te;
            }
            if (teInfo != null) {
                teInfo.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> compoundNBT.func_74776_a("pressure", h.getPressure()));
                if (teInfo.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
                    compoundNBT.func_218657_a("heatData", (INBT)new TemperatureData((ICapabilityProvider)teInfo).toNBT());
                }
            }
        }
    }
}

