/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityProvider {

    public static class Component
    implements IEntityComponentProvider {
        public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
            tooltip.add(accessor.getEntity().func_145748_c_().func_211708_a(TextFormatting.WHITE));
        }

        public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
            if (accessor.getServerData().func_74764_b("Pressure")) {
                float pressure = accessor.getServerData().func_74760_g("Pressure");
                tooltip.add((ITextComponent)new TranslationTextComponent("gui.tooltip.pressure", new Object[]{PneumaticCraftUtils.roundNumberTo(pressure, 1)}));
            }
            if (accessor.getServerData().func_74764_b("Temperature")) {
                tooltip.add(HeatUtil.formatHeatString(accessor.getServerData().func_74762_e("Temperature")));
            }
            if (accessor.getEntity() instanceof ISemiBlock) {
                ((ISemiBlock)accessor.getEntity()).addTooltip(tooltip, accessor.getPlayer(), accessor.getServerData(), accessor.getPlayer().func_225608_bj_());
            }
        }

        public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
            String modName = ModNameCache.getModName("pneumaticcraft");
            tooltip.add(new StringTextComponent(modName).func_211709_a(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        }
    }

    public static class Data
    implements IServerDataProvider<Entity> {
        public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, Entity entity) {
            entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> compoundNBT.func_74776_a("Pressure", h.getPressure()));
            entity.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> compoundNBT.func_74776_a("Temperature", (float)h.getTemperatureAsInt()));
            if (entity instanceof ISemiBlock) {
                ((ISemiBlock)entity).serializeNBT(compoundNBT);
            }
        }
    }
}

