/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;

public class JetBootsStateTracker {
    private static final JetBootsStateTracker clientTracker = new JetBootsStateTracker();
    private static final JetBootsStateTracker serverTracker = new JetBootsStateTracker();
    private final Map<UUID, JetBootsState> stateMap = new HashMap<UUID, JetBootsState>();

    private static JetBootsStateTracker getClientTracker() {
        return clientTracker;
    }

    private static JetBootsStateTracker getServerTracker() {
        return serverTracker;
    }

    public static JetBootsStateTracker getTracker(PlayerEntity player) {
        return player.field_70170_p.field_72995_K ? JetBootsStateTracker.getClientTracker() : JetBootsStateTracker.getServerTracker();
    }

    private JetBootsStateTracker() {
    }

    void setJetBootsState(PlayerEntity player, boolean enabled, boolean active, boolean builderMode) {
        if (!player.field_70170_p.field_72995_K) {
            JetBootsState state = this.stateMap.computeIfAbsent(player.func_110124_au(), uuid -> new JetBootsState(false, false, false));
            boolean sendPacket = state.enabled != enabled || state.active != active || state.builderMode != builderMode;
            state.enabled = enabled;
            state.active = active;
            state.builderMode = builderMode;
            if (sendPacket) {
                NetworkHandler.sendToDimension(new PacketJetBootsStateSync(player, state), player.field_70170_p.func_201675_m().func_186058_p());
            }
        }
    }

    public void setJetBootsState(UUID playerId, JetBootsState state) {
        this.stateMap.put(playerId, state);
    }

    public JetBootsState getJetBootsState(PlayerEntity player) {
        return this.stateMap.getOrDefault(player.func_110124_au(), new JetBootsState(false, false, false));
    }

    public void informOtherPlayers(ServerPlayerEntity newPlayer) {
        JetBootsState state;
        JetBootsStateTracker tracker = JetBootsStateTracker.getTracker((PlayerEntity)newPlayer);
        for (PlayerEntity player : newPlayer.func_130014_f_().func_217369_A()) {
            JetBootsState state2;
            if (player.func_145782_y() == newPlayer.func_145782_y() || !ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)newPlayer, EquipmentSlotType.FEET) || (state2 = tracker.getJetBootsState(player)) == null) continue;
            NetworkHandler.sendToPlayer(new PacketJetBootsStateSync(player, state2), newPlayer);
        }
        if (ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)newPlayer, EquipmentSlotType.FEET) && (state = tracker.getJetBootsState((PlayerEntity)newPlayer)) != null) {
            NetworkHandler.sendToDimension(new PacketJetBootsStateSync((PlayerEntity)newPlayer, state), newPlayer.func_130014_f_().func_201675_m().func_186058_p());
        }
    }

    public static class JetBootsState {
        private boolean enabled;
        private boolean active;
        private boolean builderMode;

        public JetBootsState(boolean enabled, boolean active, boolean builderMode) {
            this.enabled = enabled;
            this.active = active;
            this.builderMode = builderMode;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isBuilderMode() {
            return this.builderMode;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setBuilderMode(boolean builderMode) {
            this.builderMode = builderMode;
        }

        public boolean shouldRotatePlayer() {
            return this.enabled && this.active && !this.builderMode;
        }

        public String toString() {
            return String.format("[en=%b,ac=%b,bu=%b]", this.enabled, this.active, this.builderMode);
        }
    }
}

