/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum HackTickHandler {
    INSTANCE;

    private final Map<WorldAndCoord, IHackableBlock> hackedBlocks = new HashMap<WorldAndCoord, IHackableBlock>();

    public static HackTickHandler instance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.hackedBlocks.entrySet().removeIf(entry -> !((IHackableBlock)entry.getValue()).afterHackTick(((WorldAndCoord)entry.getKey()).world, ((WorldAndCoord)entry.getKey()).pos));
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                for (Entity entity : this.getAllEntities(event.world)) {
                    entity.getCapability(PNCCapabilities.HACKING_CAPABILITY, null).ifPresent(h -> {
                        if (!h.getCurrentHacks().isEmpty()) {
                            h.update(entity);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Iterable<? extends Entity> getAllEntities(World world) {
        return world.field_72995_K ? ClientUtils.getAllEntities(world) : ((ServerWorld)world).getEntities()::iterator;
    }

    public void trackBlock(WorldAndCoord coord, IHackableBlock iHackable) {
        this.hackedBlocks.put(coord, iHackable);
    }

    public void trackEntity(Entity entity, IHackableEntity iHackable) {
        if (iHackable.getHackableId() != null) {
            entity.getCapability(PNCCapabilities.HACKING_CAPABILITY, null).ifPresent(h -> h.addHackable(iHackable));
        }
    }
}

