/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.tubes.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneReceiving;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.LazyOptional;

public class ModuleRegulatorTube
extends TubeModuleRedstoneReceiving
implements IInfluenceDispersing {
    public static boolean hasTicked;
    public static boolean inLine;
    public static boolean inverted;
    private LazyOptional<IAirHandlerMachine> neighbourCap = null;

    public ModuleRegulatorTube(ItemTubeModule itemTubeModule) {
        super(itemTubeModule);
    }

    @Override
    public int getMaxDispersion() {
        return (Integer)this.getCachedNeighbourAirHandler().map(h -> {
            int maxDispersion = (int)((this.getThreshold() - h.getPressure()) * (float)h.getVolume());
            return Math.max(0, maxDispersion);
        }).orElse((Object)0);
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.neighbourCap = null;
    }

    @Override
    public float getThreshold() {
        return this.upgraded ? super.getThreshold() : 4.9f * (float)(15 - this.getReceivingRedstoneLevel()) / 15.0f;
    }

    private LazyOptional<IAirHandlerMachine> getCachedNeighbourAirHandler() {
        if (this.neighbourCap == null) {
            TileEntity neighborTE = this.pressureTube.func_145831_w().func_175625_s(this.pressureTube.func_174877_v().func_177972_a(this.dir));
            if (neighborTE != null) {
                this.neighbourCap = neighborTE.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.dir.func_176734_d());
                if (this.neighbourCap.isPresent()) {
                    this.neighbourCap.addListener(l -> {
                        this.neighbourCap = null;
                    });
                }
            } else {
                this.neighbourCap = LazyOptional.empty();
            }
        }
        return this.neighbourCap;
    }
}

