/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVacuumPump;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderVacuumPump
extends AbstractTileModelRenderer<TileEntityVacuumPump> {
    private static final int BLADE_COUNT = 3;
    private static final int CASE_POINTS = 20;
    private final ModelRenderer turbineCase = new ModelRenderer(64, 64, 0, 47);
    private final ModelRenderer top;
    private final ModelRenderer blade;
    private static final float PLUS_MINUS_SCALE = 0.05f;

    public RenderVacuumPump(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.turbineCase.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f);
        this.turbineCase.func_78793_a(-0.5f, 14.1f, 0.0f);
        this.turbineCase.field_78809_i = true;
        this.top = new ModelRenderer(64, 64, 0, 47);
        this.top.func_228300_a_(0.0f, 0.0f, 0.0f, 6.0f, 1.0f, 12.0f);
        this.top.func_78793_a(-3.0f, 13.0f, -6.0f);
        this.top.field_78809_i = true;
        this.blade = new ModelRenderer(64, 64, 0, 0);
        this.blade.func_228300_a_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 2.0f);
        this.blade.func_78793_a(-0.5f, 14.0f, -3.0f);
        this.blade.field_78809_i = true;
    }

    @Override
    public void renderModel(TileEntityVacuumPump te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)Textures.MODEL_VACUUM_PUMP));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        this.renderBlades(te, partialTicks, matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.renderCase(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        this.renderPlusAndMinus(matrixStackIn, bufferIn);
    }

    private void renderBlades(TileEntityVacuumPump te, float partialTicks, MatrixStack matrixStackIn, IVertexBuilder builder, int combinedLightIn, int combinedOverlayIn) {
        int i;
        float rotation = MathHelper.func_219799_g((float)partialTicks, (float)te.oldRotation, (float)te.rotation) + 1.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.0, 0.1875);
        for (i = 0; i < 3; ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation * 2.0f + ((float)i + 0.5f) / 3.0f * 360.0f));
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0625);
            this.blade.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.0, 0.1875);
        for (i = 0; i < 3; ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotation * 2.0f + (float)i / 3.0f * 360.0f));
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0625);
            this.blade.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    private void renderCase(MatrixStack matrixStackIn, IVertexBuilder builder, int combinedLightIn, int combinedOverlayIn) {
        int i;
        matrixStackIn.func_227861_a_(0.0, -0.01, 0.0);
        this.top.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 0.4f);
        matrixStackIn.func_227861_a_(0.0, 0.01, 0.0);
        matrixStackIn.func_227860_a_();
        for (i = 0; i < 20; ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.1875);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i / 20.0f * 275.0f - 130.0f));
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.15625);
            this.turbineCase.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 0.5f, 0.5f, 0.5f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        for (i = 0; i < 20; ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.1875);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i / 20.0f * 275.0f - 130.0f));
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.15625);
            this.turbineCase.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 0.5f, 0.5f, 0.5f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    private void renderPlusAndMinus(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        matrixStackIn.func_227860_a_();
        IVertexBuilder builder = bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_);
        matrixStackIn.func_227861_a_(0.26, 0.871875, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStackIn.func_227862_a_(0.05f, 0.05f, 0.05f);
        Matrix4f posMat = matrixStackIn.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(posMat, -1.0f, 0.0f, 0.0f).func_225586_a_(0, 255, 0, 255).func_181675_d();
        builder.func_227888_a_(posMat, 1.0f, 0.0f, 0.0f).func_225586_a_(0, 255, 0, 255).func_181675_d();
        builder.func_227888_a_(posMat, 0.0f, -1.0f, 0.0f).func_225586_a_(0, 255, 0, 255).func_181675_d();
        builder.func_227888_a_(posMat, 0.0f, 1.0f, 0.0f).func_225586_a_(0, 255, 0, 255).func_181675_d();
        matrixStackIn.func_227861_a_(-10.399999845027926, 0.0, 0.0);
        posMat = matrixStackIn.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(posMat, -1.0f, 0.0f, 0.0f).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_227888_a_(posMat, 1.0f, 0.0f, 0.0f).func_225586_a_(255, 0, 0, 255).func_181675_d();
        matrixStackIn.func_227865_b_();
    }
}

