/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class WidgetFluidFilter
extends Widget
implements ITooltipProvider {
    final Consumer<WidgetFluidFilter> pressable;
    protected FluidStack fluidStack;

    public WidgetFluidFilter(int x, int y, Fluid fluid) {
        this(x, y, fluid, null);
    }

    public WidgetFluidFilter(int x, int y, Fluid fluid, Consumer<WidgetFluidFilter> pressable) {
        this(x, y, new FluidStack(fluid, 1000), pressable);
    }

    WidgetFluidFilter(int x, int y, FluidStack fluidStack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, 16, 16, "");
        this.pressable = pressable;
        this.fluidStack = fluidStack;
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        if (!this.fluidStack.isEmpty()) {
            GuiUtils.drawFluid(new Rectangle2d(this.x, this.y, 16, 16), new FluidStack(this.fluidStack, 1000), null);
        }
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shiftPressed) {
        if (!this.fluidStack.isEmpty()) {
            curTip.add(new FluidStack(this.fluidStack, 1).getDisplayName().func_150254_d());
            curTip.add(TextFormatting.BLUE + "" + TextFormatting.ITALIC + ModNameCache.getModName(this.fluidStack.getFluid().getRegistryName().func_110624_b()));
        }
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    public WidgetFluidFilter setFluid(Fluid fluid) {
        this.fluidStack = new FluidStack(fluid, 1000);
        return this;
    }

    public void onClick(double x, double y) {
        super.onClick(x, y);
        if (this.pressable != null) {
            this.pressable.accept(this);
        }
    }
}

