/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.ITickableWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MainHelmetHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiMoveStat
extends GuiPneumaticScreenBase {
    private final IGuiAnimatedStat movedStat;
    private final IUpgradeRenderHandler renderHandler;
    private boolean clicked = false;
    private final List<IGuiAnimatedStat> otherStats = new ArrayList<IGuiAnimatedStat>();
    private final List<String> helpText = new ArrayList<String>();
    private final ArmorHUDLayout.LayoutTypes layoutItem;
    private WidgetCheckBox snapToGrid;
    private Slider gridSlider;
    private static boolean snap = false;
    private static int gridSize = 4;

    GuiMoveStat(IUpgradeRenderHandler renderHandler, ArmorHUDLayout.LayoutTypes layoutItem) {
        this(renderHandler, layoutItem, renderHandler.getAnimatedStat());
    }

    GuiMoveStat(IUpgradeRenderHandler renderHandler, ArmorHUDLayout.LayoutTypes layoutItem, @Nonnull IGuiAnimatedStat movedStat) {
        super((ITextComponent)new StringTextComponent("Move Gui"));
        this.movedStat = movedStat;
        this.renderHandler = renderHandler;
        this.layoutItem = layoutItem;
        movedStat.openWindow();
        CommonArmorHandler hudHandler = CommonArmorHandler.getHandlerForPlayer();
        for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IGuiAnimatedStat stat;
                IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                if (!hudHandler.isUpgradeRendererInserted(slot, i) || !hudHandler.isUpgradeRendererEnabled(slot, i) || (stat = upgradeRenderHandler.getAnimatedStat()) == null || stat == movedStat) continue;
                this.otherStats.add(stat);
            }
        }
        MainHelmetHandler mainOptions = HUDHandler.instance().getSpecificRenderer(MainHelmetHandler.class);
        if (movedStat != mainOptions.testMessageStat) {
            mainOptions.testMessageStat = new WidgetAnimatedStat(null, "Test Message, keep in mind messages can be long!", WidgetAnimatedStat.StatIcon.NONE, 0x7000AA00, null, ArmorHUDLayout.INSTANCE.messageStat);
            mainOptions.testMessageStat.openWindow();
            this.otherStats.add(mainOptions.testMessageStat);
        }
    }

    @Override
    public void init() {
        super.init();
        this.snapToGrid = new WidgetCheckBox(10, this.height * 3 / 5, 0xC0C0C0, "Snap To Grid");
        this.snapToGrid.x = (this.width - this.snapToGrid.getWidth()) / 2;
        this.snapToGrid.checked = snap;
        this.addButton(this.snapToGrid);
        this.gridSlider = new Slider(this.snapToGrid.x, this.snapToGrid.y + 12, this.snapToGrid.getWidth(), 10, "", "", 1.0, 12.0, (double)gridSize, false, true, b -> {}, null);
        this.addButton((Widget)this.gridSlider);
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.movedStat.getBounds().func_199315_b((int)mouseX, (int)mouseY)) {
            if (mouseButton == 2) {
                this.movedStat.setLeftSided(!this.movedStat.isLeftSided());
                this.save();
            } else if (mouseButton < 2) {
                this.clicked = true;
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.clicked) {
            if (mouseButton == 0 || mouseButton == 1) {
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            this.save();
            this.clicked = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.clicked) {
            this.reposition(this.movedStat, mouseX, mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dx, dy);
    }

    private void reposition(IGuiAnimatedStat stat, double x, double y) {
        if (snap) {
            x -= x % (double)gridSize;
            y -= y % (double)gridSize;
        }
        stat.setBaseX((int)x);
        stat.setBaseY((int)y);
    }

    public void onClose() {
        this.minecraft.func_147108_a((Screen)GuiHelmetMainScreen.getInstance());
    }

    @Override
    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        GuiUtils.showPopupHelpScreen(this, this.font, this.helpText);
        super.render(x, y, partialTicks);
        this.movedStat.render(-1, -1, partialTicks);
        this.otherStats.forEach(stat -> {
            int c = stat.getBackgroundColor();
            stat.setBackgroundColor(0x30606060);
            stat.render(-1, -1, partialTicks);
            stat.setBackgroundColor(c);
        });
    }

    @Override
    public void tick() {
        super.tick();
        snap = this.snapToGrid.checked;
        gridSize = this.gridSlider.getValueInt();
        this.gridSlider.visible = snap;
        this.movedStat.tickWidget();
        this.otherStats.forEach(ITickableWidget::tickWidget);
        if (this.helpText.isEmpty()) {
            this.helpText.add(TextFormatting.GREEN + "" + TextFormatting.UNDERLINE + "Moving: " + I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + this.renderHandler.getUpgradeID()), (Object[])new Object[0]));
            this.helpText.add("");
            this.helpText.add("Left- or Right-Click: move the highlighted stat");
            this.helpText.add("...");
        }
        this.helpText.set(3, "Stat expands " + this.getDir(this.movedStat.isLeftSided()) + ". Middle-click: expand " + this.getDir(!this.movedStat.isLeftSided()));
    }

    private String getDir(boolean left) {
        return TextFormatting.YELLOW + (left ? "Left" : "Right") + TextFormatting.RESET;
    }

    private void save() {
        MainWindow sr = this.minecraft.func_228018_at_();
        ArmorHUDLayout.INSTANCE.updateLayout(this.layoutItem, (float)this.movedStat.getBaseX() / (float)sr.func_198107_o(), (float)this.movedStat.getBaseY() / (float)sr.func_198087_p(), this.movedStat.isLeftSided());
    }
}

