/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerPressureChamberInterface;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberInterface;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiPressureChamberInterface
extends GuiPneumaticContainerBase<ContainerPressureChamberInterface, TileEntityPressureChamberInterface> {
    private WidgetAnimatedStat statusStat;
    private WidgetButtonExtended exportAnyButton;
    private WidgetLabel exportTypeLabel;
    private boolean hasEnoughPressure = true;

    public GuiPressureChamberInterface(ContainerPressureChamberInterface container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat("gui.pressureChamberInterface.status", new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), -22016, false);
        this.exportAnyButton = (WidgetButtonExtended)this.addButton((Widget)new WidgetButtonExtended(this.field_147003_i + 111, this.field_147009_r + 32, 60, 20, "").withTag("export_mode"));
        this.exportTypeLabel = (WidgetLabel)this.addButton(new WidgetLabel(this.field_147003_i + 111, this.field_147009_r + 20, I18n.func_135052_a((String)"gui.pressureChamberInterface.exportLabel", (Object[])new Object[0])));
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        int inputShift = (int)((1.0f - (float)Math.cos((double)(((TileEntityPressureChamberInterface)this.te).inputProgress / 40.0f) * Math.PI)) * 11.0f);
        int outputShift = (int)((1.0f - (float)Math.cos((double)(((TileEntityPressureChamberInterface)this.te).outputProgress / 40.0f) * Math.PI)) * 11.0f);
        GuiPressureChamberInterface.fill((int)(63 + inputShift), (int)30, (int)(87 + inputShift), (int)32, (int)-10853633);
        GuiPressureChamberInterface.fill((int)(63 + outputShift), (int)54, (int)(87 + outputShift), (int)56, (int)-22528);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -2);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_PRESSURE_CHAMBER_INTERFACE;
    }

    @Override
    public void tick() {
        super.tick();
        boolean exporting = ((TileEntityPressureChamberInterface)this.te).interfaceMode == TileEntityPressureChamberInterface.InterfaceDirection.EXPORT;
        this.exportAnyButton.setVisible(exporting);
        this.exportAnyButton.visible = exporting;
        this.exportTypeLabel.visible = exporting;
        if (this.exportAnyButton.visible) {
            String textKey = "gui.pressureChamberInterface.export." + (((TileEntityPressureChamberInterface)this.te).exportAny ? "any" : "valid");
            this.exportAnyButton.setMessage(I18n.func_135052_a((String)textKey, (Object[])new Object[0]));
            this.exportAnyButton.setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)(textKey + ".tooltip"), (Object[])new Object[0]), 35));
        }
        this.statusStat.setText((List<String>)ImmutableList.of((Object)(TextFormatting.WHITE + I18n.func_135052_a((String)"gui.pressureChamberInterface.mode", (Object[])new Object[0])), (Object)(TextFormatting.BLACK + I18n.func_135052_a((String)((TileEntityPressureChamberInterface)this.te).interfaceMode.getTranslationKey(), (Object[])new Object[0]))));
        if (this.hasEnoughPressure && !((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = false;
            this.problemTab.openWindow();
        } else if (((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = true;
        }
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        curInfo.addAll(((TileEntityPressureChamberInterface)this.te).getProblemStat());
    }
}

