/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticDynamo;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDynamo;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GuiPneumaticDynamo
extends GuiPneumaticContainerBase<ContainerPneumaticDynamo, TileEntityPneumaticDynamo> {
    private WidgetAnimatedStat inputStat;

    public GuiPneumaticDynamo(ContainerPneumaticDynamo container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.inputStat = this.addAnimatedStat("Output", Textures.GUI_BUILDCRAFT_ENERGY, -11184811, false);
        ((TileEntityPneumaticDynamo)this.te).getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
            WidgetEnergy cfr_ignored_0 = (WidgetEnergy)this.addButton(new WidgetEnergy(this.field_147003_i + 20, this.field_147009_r + 20, (IEnergyStorage)storage));
        });
        this.addButton(new WidgetTemperature(this.field_147003_i + 87, this.field_147009_r + 20, 273, 675, (LazyOptional<IHeatExchangerLogic>)((TileEntityPneumaticDynamo)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY), 325, 625));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    public void tick() {
        super.tick();
        this.inputStat.setText(this.getOutputStat());
    }

    private List<String> getOutputStat() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(TextFormatting.GRAY + "Maximum RF production:");
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityPneumaticDynamo)this.te).getRFRate() + " RF/tick");
        textList.add(TextFormatting.GRAY + "Maximum output rate:");
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityPneumaticDynamo)this.te).getRFRate() * 2 + " RF/tick");
        textList.add(TextFormatting.GRAY + "Current stored RF:");
        textList.add(TextFormatting.BLACK.toString() + ((TileEntityPneumaticDynamo)this.te).getInfoEnergyStored() + " RF");
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.tooltip.maxUsage", (Object[])new Object[]{((TileEntityPneumaticDynamo)this.te).getAirRate()}));
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityPneumaticDynamo)this.te).getEfficiency() < 100) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.advancedAirCompressor.efficiency", (Object[])new Object[]{((TileEntityPneumaticDynamo)this.te).getEfficiency() + "%%"}));
        }
    }
}

