/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.crafting.ingredient;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.lib.Constants;

public final class BatteryIngredient
extends Ingredient {
    public static final ResourceLocation NAME = SuperMultiDrills.getId("battery");
    public static final Serializer SERIALIZER = new Serializer();
    private static ItemStack[] MATCHING_STACKS;

    private BatteryIngredient() {
        super(Stream.of(new Ingredient.IItemList[0]));
    }

    public ItemStack[] func_193365_a() {
        BatteryIngredient.determineMatchingStacks();
        return MATCHING_STACKS;
    }

    private static void determineMatchingStacks() {
        if (MATCHING_STACKS == null) {
            MATCHING_STACKS = (ItemStack[])ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(BatteryIngredient::isDrillBattery).toArray(ItemStack[]::new);
        }
    }

    private static boolean isDrillBattery(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(Constants.DRILL_BATTERIES_TAG) && stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && BatteryIngredient.isDrillBattery(stack);
    }

    public boolean func_203189_d() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static final class Serializer
    implements IIngredientSerializer<BatteryIngredient> {
        public BatteryIngredient parse(PacketBuffer buffer) {
            return new BatteryIngredient();
        }

        public BatteryIngredient parse(JsonObject json) {
            return new BatteryIngredient();
        }

        public void write(PacketBuffer buffer, BatteryIngredient ingredient) {
        }
    }
}

