/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.varia.Counter;
import mcjty.lostcities.worldgen.lost.cityassets.AbstractAssetRegistry;
import mcjty.lostcities.worldgen.lost.cityassets.Building;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.Condition;
import mcjty.lostcities.worldgen.lost.cityassets.MultiBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedSphere;
import mcjty.lostcities.worldgen.lost.cityassets.Style;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;

public class AssetRegistries {
    public static final AbstractAssetRegistry<Condition> CONDITIONS = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<WorldStyle> WORLDSTYLES = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<CityStyle> CITYSTYLES = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<BuildingPart> PARTS = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<Building> BUILDINGS = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<MultiBuilding> MULTI_BUILDINGS = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<Style> STYLES = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<Palette> PALETTES = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<PredefinedCity> PREDEFINED_CITIES = new AbstractAssetRegistry();
    public static final AbstractAssetRegistry<PredefinedSphere> PREDEFINED_SPHERES = new AbstractAssetRegistry();

    public static final void reset() {
        CONDITIONS.reset();
        WORLDSTYLES.reset();
        PARTS.reset();
        BUILDINGS.reset();
        CITYSTYLES.reset();
        MULTI_BUILDINGS.reset();
        STYLES.reset();
        PALETTES.reset();
        PREDEFINED_CITIES.reset();
        PREDEFINED_SPHERES.reset();
    }

    public static void load(File file) {
        try (FileInputStream in2 = new FileInputStream(file);){
            AssetRegistries.load(in2, file.getName());
        }
        catch (FileNotFoundException in2) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void add(Map<Character, Set<String>> map, Character character, String partName) {
        if (!map.containsKey(character)) {
            map.put(character, new HashSet());
        }
        map.get(character).add(partName);
    }

    public static void showStatistics() {
        Counter<Character> counterLocal = new Counter<Character>();
        Counter<Character> counterGlobal = new Counter<Character>();
        HashMap<Character, Set<String>> usersPerCharacter = new HashMap<Character, Set<String>>();
        for (BuildingPart part : PARTS.getIterable()) {
            Palette localPalette = part.getLocalPalette();
            Map<Object, Object> palette = Collections.emptyMap();
            if (localPalette != null) {
                palette = localPalette.palette;
            }
            for (int x = 0; x < part.getXSize(); ++x) {
                for (int z = 0; z < part.getZSize(); ++z) {
                    char[] slice = part.getVSlice(x, z);
                    if (slice == null) continue;
                    for (char c : slice) {
                        if (palette.containsKey(Character.valueOf(c))) {
                            counterLocal.add(Character.valueOf(c));
                        } else {
                            counterGlobal.add(Character.valueOf(c));
                        }
                        AssetRegistries.add(usersPerCharacter, Character.valueOf(c), part.getName());
                    }
                }
            }
        }
        ArrayList<Map.Entry<Character, Integer>> global = new ArrayList<Map.Entry<Character, Integer>>(counterGlobal.getMap().entrySet());
        ArrayList<Map.Entry<Character, Integer>> local = new ArrayList<Map.Entry<Character, Integer>>(counterLocal.getMap().entrySet());
        global.sort((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue()));
        local.sort((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue()));
        LostCities.setup.getLogger().info("############################################################################");
        LostCities.setup.getLogger().info("Global palette entries");
        AssetRegistries.printMap(usersPerCharacter, global);
        LostCities.setup.getLogger().info("----------------------------------------------------------------------------");
        LostCities.setup.getLogger().info("Local palette entries");
        AssetRegistries.printMap(usersPerCharacter, local);
        LostCities.setup.getLogger().info("----------------------------------------------------------------------------");
        AssetRegistries.printChars("Global: ", counterGlobal);
        AssetRegistries.printChars("Local: ", counterLocal);
        LostCities.setup.getLogger().info("############################################################################");
    }

    private static void printChars(String prefix, Counter<Character> counter) {
        ArrayList<Character> chars = new ArrayList<Character>(counter.getMap().keySet());
        chars.sort((o1, o2) -> o1.compareTo((Character)o2));
        String s = "";
        for (Character character : chars) {
            s = s + character;
        }
        LostCities.setup.getLogger().info(prefix + s);
    }

    private static void printMap(Map<Character, Set<String>> usersPerCharacter, List<Map.Entry<Character, Integer>> map) {
        for (Map.Entry<Character, Integer> entry : map) {
            Set<String> users = usersPerCharacter.get(entry.getKey());
            String s = "    " + entry.getKey() + ": " + entry.getValue() + " Uses";
            if (users.size() < 10) {
                s = s + ", Used by: ";
                for (String user : users) {
                    s = s + user + ",";
                }
            } else {
                s = s + ", Used " + users.size() + " times";
            }
            LostCities.setup.getLogger().info(s);
        }
    }

    public static void load(InputStream inputstream, String filename) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)br);
            for (JsonElement entry : element.getAsJsonArray()) {
                JsonObject object = entry.getAsJsonObject();
                String type = object.get("type").getAsString();
                if ("style".equals(type)) {
                    STYLES.register(new Style(object));
                    continue;
                }
                if ("condition".equals(type)) {
                    CONDITIONS.register(new Condition(object));
                    continue;
                }
                if ("palette".equals(type)) {
                    PALETTES.register(new Palette(object));
                    continue;
                }
                if ("citystyle".equals(type)) {
                    CITYSTYLES.register(new CityStyle(object));
                    continue;
                }
                if ("part".equals(type)) {
                    PARTS.register(new BuildingPart(object));
                    continue;
                }
                if ("building".equals(type)) {
                    BUILDINGS.register(new Building(object));
                    continue;
                }
                if ("multibuilding".equals(type)) {
                    MULTI_BUILDINGS.register(new MultiBuilding(object));
                    continue;
                }
                if ("worldstyle".equals(type)) {
                    WORLDSTYLES.register(new WorldStyle(object));
                    continue;
                }
                if ("city".equals(type)) {
                    PREDEFINED_CITIES.register(new PredefinedCity(object));
                    continue;
                }
                if ("sphere".equals(type)) {
                    PREDEFINED_SPHERES.register(new PredefinedSphere(object));
                    continue;
                }
                throw new RuntimeException("Unknown type '" + type + " in " + filename + "'!");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

