/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.helper.Vector3;

public class EntityMagicMissile
extends ThrowableEntity {
    @ObjectHolder(value="botania:magic_missile")
    public static EntityType<EntityMagicMissile> TYPE;
    private static final String TAG_TIME = "time";
    private static final DataParameter<Boolean> EVIL;
    private static final DataParameter<Integer> TARGET;
    double lockX;
    double lockY = -1.0;
    double lockZ;
    int time = 0;

    public EntityMagicMissile(EntityType<EntityMagicMissile> type, World world) {
        super(type, world);
    }

    public EntityMagicMissile(World world) {
        this(TYPE, world);
    }

    public EntityMagicMissile(LivingEntity thrower, boolean evil) {
        super(TYPE, thrower, thrower.field_70170_p);
        this.setEvil(evil);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EVIL, (Object)false);
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setEvil(boolean evil) {
        this.field_70180_af.func_187227_b(EVIL, (Object)evil);
    }

    public boolean isEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(EVIL);
    }

    public void setTarget(LivingEntity e) {
        this.field_70180_af.func_187227_b(TARGET, (Object)(e == null ? -1 : e.func_145782_y()));
    }

    public LivingEntity getTargetEntity() {
        int id = (Integer)this.field_70180_af.func_187225_a(TARGET);
        Entity e = this.field_70170_p.func_73045_a(id);
        if (e != null && e instanceof LivingEntity) {
            return (LivingEntity)e;
        }
        return null;
    }

    public void func_70071_h_() {
        double lastTickPosX = this.field_70142_S;
        double lastTickPosY = this.field_70137_T;
        double lastTickPosZ = this.field_70136_U;
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.findTarget() && this.time <= 40)) {
            this.func_70106_y();
            return;
        }
        boolean evil = this.isEvil();
        Vector3 thisVec = Vector3.fromEntityCenter((Entity)this);
        Vector3 oldPos = new Vector3(lastTickPosX, lastTickPosY, lastTickPosZ);
        Vector3 diff = thisVec.subtract(oldPos);
        Vector3 step = diff.normalize().multiply(0.05);
        int steps = (int)(diff.mag() / step.mag());
        Vector3 particlePos = oldPos;
        SparkleParticleData data = evil ? SparkleParticleData.corrupt(0.8f, 1.0f, 0.0f, 1.0f, 2) : SparkleParticleData.sparkle(0.8f, 1.0f, 0.4f, 1.0f, 2);
        for (int i = 0; i < steps; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)data, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.0, 0.0);
            if (this.field_70170_p.field_73012_v.nextInt(steps) <= 1) {
                this.field_70170_p.func_195594_a((IParticleData)data, particlePos.x + (Math.random() - 0.5) * 0.4, particlePos.y + (Math.random() - 0.5) * 0.4, particlePos.z + (Math.random() - 0.5) * 0.4, 0.0, 0.0, 0.0);
            }
            particlePos = particlePos.add(step);
        }
        LivingEntity target = this.getTargetEntity();
        if (target != null) {
            List targetList;
            if (this.lockY == -1.0) {
                this.lockX = target.func_226277_ct_();
                this.lockY = target.func_226278_cu_();
                this.lockZ = target.func_226281_cx_();
            }
            Vector3 targetVec = evil ? new Vector3(this.lockX, this.lockY, this.lockZ) : Vector3.fromEntityCenter((Entity)target);
            Vector3 diffVec = targetVec.subtract(thisVec);
            Vector3 motionVec = diffVec.normalize().multiply(evil ? 0.5 : 0.6);
            this.func_213317_d(motionVec.toVec3D());
            if (this.time < 10) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), Math.abs(this.func_213322_ci().func_82617_b()), this.func_213322_ci().func_82616_c());
            }
            if ((targetList = this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_226277_ct_() - 0.5, this.func_226278_cu_() - 0.5, this.func_226281_cx_() - 0.5, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5))).contains(target)) {
                LivingEntity thrower = this.func_85052_h();
                if (thrower != null) {
                    PlayerEntity player = thrower instanceof PlayerEntity ? (PlayerEntity)thrower : null;
                    target.func_70097_a(player == null ? DamageSource.func_76358_a((LivingEntity)thrower) : DamageSource.func_76365_a((PlayerEntity)player), evil ? 12.0f : 7.0f);
                } else {
                    target.func_70097_a(DamageSource.field_76377_j, evil ? 12.0f : 7.0f);
                }
                this.func_70106_y();
            }
            if (evil && diffVec.mag() < 1.0) {
                this.func_70106_y();
            }
        }
        ++this.time;
    }

    public void func_213281_b(CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74768_a(TAG_TIME, this.time);
    }

    public void func_70037_a(CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.time = cmp.func_74762_e(TAG_TIME);
    }

    public boolean findTarget() {
        LivingEntity target = this.getTargetEntity();
        if (target != null && target.func_70089_S()) {
            return true;
        }
        if (target != null) {
            this.setTarget(null);
        }
        double range = 12.0;
        AxisAlignedBB bounds = new AxisAlignedBB(this.func_226277_ct_() - range, this.func_226278_cu_() - range, this.func_226281_cx_() - range, this.func_226277_ct_() + range, this.func_226278_cu_() + range, this.func_226281_cx_() + range);
        List entities = this.isEvil() ? this.field_70170_p.func_217357_a(PlayerEntity.class, bounds) : this.field_70170_p.func_175647_a(Entity.class, bounds, (Predicate)Predicates.instanceOf(IMob.class));
        while (entities.size() > 0) {
            Entity e = (Entity)entities.get(this.field_70170_p.field_73012_v.nextInt(entities.size()));
            if (!(e instanceof LivingEntity) || !e.func_70089_S()) {
                entities.remove(e);
                continue;
            }
            target = (LivingEntity)e;
            this.setTarget(target);
            break;
        }
        return target != null;
    }

    protected void func_70184_a(@Nonnull RayTraceResult pos) {
        switch (pos.func_216346_c()) {
            case BLOCK: {
                Block block = this.field_70170_p.func_180495_p(((BlockRayTraceResult)pos).func_216350_a()).func_177230_c();
                if (block instanceof BushBlock || block instanceof LeavesBlock) break;
                this.func_70106_y();
                break;
            }
            case ENTITY: {
                if (((EntityRayTraceResult)pos).func_216348_a() != this.getTargetEntity()) break;
                this.func_70106_y();
                break;
            }
            default: {
                this.func_70106_y();
            }
        }
    }

    static {
        EVIL = EntityDataManager.func_187226_a(EntityMagicMissile.class, (IDataSerializer)DataSerializers.field_187198_h);
        TARGET = EntityDataManager.func_187226_a(EntityMagicMissile.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

