/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.common.item.ModItems;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityEnderAirBottle
extends ThrowableEntity
implements IRendersAsItem {
    @ObjectHolder(value="botania:ender_air_bottle")
    public static EntityType<EntityEnderAirBottle> TYPE;

    public EntityEnderAirBottle(EntityType<EntityEnderAirBottle> type, World world) {
        super(type, world);
    }

    public EntityEnderAirBottle(LivingEntity entity, World world) {
        super(TYPE, entity, world);
    }

    protected void func_70184_a(@Nonnull RayTraceResult pos) {
        if (pos.func_216346_c() == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K) {
            List<BlockPos> coordsList = this.getCoordsToPut(((BlockRayTraceResult)pos).func_216350_a());
            this.field_70170_p.func_217379_c(2002, new BlockPos((Entity)this), 8);
            for (BlockPos coords : coordsList) {
                this.field_70170_p.func_175656_a(coords, Blocks.field_150377_bs.func_176223_P());
                if (!(Math.random() < 0.1)) continue;
                this.field_70170_p.func_217379_c(2001, coords, Block.func_196246_j((BlockState)Blocks.field_150377_bs.func_176223_P()));
            }
            this.func_70106_y();
        }
    }

    private List<BlockPos> getCoordsToPut(BlockPos pos) {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = 4;
        int rangeY = 4;
        for (BlockPos bPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, -rangeY, -range), (BlockPos)pos.func_177982_a(range, rangeY, range))) {
            BlockState state = this.field_70170_p.func_180495_p(bPos);
            Block block = state.func_177230_c();
            if (!block.isReplaceableOreGen(state, (IWorldReader)this.field_70170_p, bPos, (Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150348_b))) continue;
            possibleCoords.add(bPos.func_185334_h());
        }
        Collections.shuffle(possibleCoords, this.field_70146_Z);
        return possibleCoords.stream().limit(64L).collect(Collectors.toList());
    }

    protected void func_70088_a() {
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ModItems.enderAirBottle);
    }
}

