/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.terminal.CraftingTerminalTileEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class CraftingTerminalGui
extends ItemTerminalGui {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/crafting_terminal.png");
    private Button requestButton;

    public CraftingTerminalGui(ItemTerminalContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_146999_f = 256;
    }

    @Override
    protected void init() {
        super.init();
        this.requestButton = (Button)this.addButton((Widget)new Button(this.field_147003_i + 8, this.field_147009_r + 100, 50, 20, I18n.func_135052_a((String)"info.prettypipes.request", (Object[])new Object[0]), button -> {
            int all = CraftingTerminalGui.hasShiftDown() ? 1 : 0;
            PacketHandler.sendToServer(new PacketButton(((ItemTerminalContainer)this.field_147002_h).tile.func_174877_v(), PacketButton.ButtonResult.CRAFT_TERMINAL_REQUEST, all));
        }));
        this.tick();
    }

    @Override
    public void tick() {
        super.tick();
        CraftingTerminalTileEntity tile = this.getCraftingContainer().getTile();
        this.requestButton.active = false;
        for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
            ItemStack stack = tile.getRequestedCraftItem(i);
            if (stack.func_190926_b() || stack.func_190916_E() >= stack.func_77976_d()) continue;
            this.requestButton.active = true;
            break;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        CraftingTerminalContainer container = this.getCraftingContainer();
        CraftingTerminalTileEntity tile = container.getTile();
        for (int i = 0; i < tile.ghostItems.getSlots(); ++i) {
            ItemStack ghost;
            if (!tile.craftItems.getStackInSlot(i).func_190926_b() || (ghost = tile.ghostItems.getStackInSlot(i)).func_190926_b()) continue;
            int finalI = i;
            Slot slot = container.field_75151_b.stream().filter(s -> s.field_75224_c == container.craftInventory && s.getSlotIndex() == finalI).findFirst().orElse(null);
            if (slot == null) continue;
            this.minecraft.func_175599_af().func_175042_a(ghost, slot.field_75223_e, slot.field_75221_f);
            this.minecraft.func_175599_af().func_180453_a(this.font, ghost, slot.field_75223_e, slot.field_75221_f, "0");
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getXOffset() {
        return 65;
    }

    protected CraftingTerminalContainer getCraftingContainer() {
        return (CraftingTerminalContainer)this.field_147002_h;
    }
}

