/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Streams;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketItemEnterPipe;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jgrapht.GraphPath;
import org.jgrapht.ListenableGraph;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class PipeNetwork
implements ICapabilitySerializable<CompoundNBT>,
GraphListener<BlockPos, NetworkEdge> {
    public final ListenableGraph<BlockPos, NetworkEdge> graph;
    private final DijkstraShortestPath<BlockPos, NetworkEdge> dijkstra;
    private final Map<BlockPos, List<BlockPos>> nodeToConnectedNodes = new HashMap<BlockPos, List<BlockPos>>();
    private final Map<BlockPos, PipeTileEntity> tileCache = new HashMap<BlockPos, PipeTileEntity>();
    private final ListMultimap<BlockPos, PipeItem> pipeItems = ArrayListMultimap.create();
    private final ListMultimap<BlockPos, NetworkLock> networkLocks = ArrayListMultimap.create();
    private final World world;

    public PipeNetwork(World world) {
        this.world = world;
        this.graph = new DefaultListenableGraph<BlockPos, NetworkEdge>(new SimpleWeightedGraph(NetworkEdge.class));
        this.graph.addGraphListener(this);
        this.dijkstra = new DijkstraShortestPath<BlockPos, NetworkEdge>(this.graph);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == Registry.pipeNetworkCapability ? LazyOptional.of(() -> this) : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT nodes = new ListNBT();
        for (BlockPos node : this.graph.vertexSet()) {
            nodes.add((Object)NBTUtil.func_186859_a((BlockPos)node));
        }
        nbt.func_218657_a("nodes", (INBT)nodes);
        ListNBT edges = new ListNBT();
        for (NetworkEdge edge : this.graph.edgeSet()) {
            edges.add((Object)edge.serializeNBT());
        }
        nbt.func_218657_a("edges", (INBT)edges);
        nbt.func_218657_a("items", (INBT)Utility.serializeAll(this.pipeItems.values()));
        nbt.func_218657_a("locks", (INBT)Utility.serializeAll(this.networkLocks.values()));
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.graph.removeAllVertices(new ArrayList(this.graph.vertexSet()));
        this.pipeItems.clear();
        this.networkLocks.clear();
        ListNBT nodes = nbt.func_150295_c("nodes", 10);
        for (int i = 0; i < nodes.size(); ++i) {
            this.graph.addVertex(NBTUtil.func_186861_c((CompoundNBT)nodes.func_150305_b(i)));
        }
        ListNBT edges = nbt.func_150295_c("edges", 10);
        for (int i = 0; i < edges.size(); ++i) {
            this.addEdge(new NetworkEdge(edges.func_150305_b(i)));
        }
        for (PipeItem item : Utility.deserializeAll(nbt.func_150295_c("items", 10), PipeItem::new)) {
            this.pipeItems.put((Object)item.getCurrentPipe(), (Object)item);
        }
        for (NetworkLock lock : Utility.deserializeAll(nbt.func_150295_c("locks", 10), NetworkLock::new)) {
            this.createNetworkLock(lock);
        }
    }

    public void addNode(BlockPos pos, BlockState state) {
        if (!this.isNode(pos)) {
            this.graph.addVertex(pos);
            this.refreshNode(pos, state);
        }
    }

    public void removeNode(BlockPos pos) {
        if (this.isNode(pos)) {
            this.graph.removeVertex(pos);
        }
    }

    public boolean isNode(BlockPos pos) {
        return this.graph.containsVertex(pos);
    }

    public void onPipeChanged(BlockPos pos, BlockState state) {
        List<NetworkEdge> neighbors = this.createAllEdges(pos, state, true);
        if (neighbors.size() <= 1 && !this.isNode(pos)) {
            return;
        }
        for (NetworkEdge edge : neighbors) {
            BlockPos end = edge.getEndPipe();
            this.refreshNode(end, this.world.func_180495_p(end));
        }
    }

    public ItemStack tryInsertItem(BlockPos startPipePos, BlockPos startInventory, ItemStack stack, boolean preventOversending) {
        return this.routeItem(startPipePos, startInventory, stack, PipeItem::new, preventOversending);
    }

    public ItemStack routeItem(BlockPos startPipePos, BlockPos startInventory, ItemStack stack, BiFunction<ItemStack, Float, PipeItem> itemSupplier, boolean preventOversending) {
        if (!this.isNode(startPipePos)) {
            return stack;
        }
        if (!this.world.func_175667_e(startPipePos)) {
            return stack;
        }
        PipeTileEntity startPipe = this.getPipe(startPipePos);
        if (startPipe == null) {
            return stack;
        }
        this.startProfile("find_destination");
        for (BlockPos pipePos : this.getOrderedNetworkNodes(startPipePos)) {
            PipeTileEntity pipe;
            Pair<BlockPos, ItemStack> dest;
            if (!this.world.func_175667_e(pipePos) || (dest = (pipe = this.getPipe(pipePos)).getAvailableDestination(stack, false, preventOversending)) == null || ((BlockPos)dest.getLeft()).equals((Object)startInventory)) continue;
            Function<Float, PipeItem> sup = speed -> (PipeItem)itemSupplier.apply((ItemStack)dest.getRight(), (Float)speed);
            if (!this.routeItemToLocation(startPipePos, startInventory, pipe.func_174877_v(), (BlockPos)dest.getLeft(), sup)) continue;
            ItemStack remain = stack.func_77946_l();
            remain.func_190918_g(((ItemStack)dest.getRight()).func_190916_E());
            this.endProfile();
            return remain;
        }
        this.endProfile();
        return stack;
    }

    public boolean routeItemToLocation(BlockPos startPipePos, BlockPos startInventory, BlockPos destPipePos, BlockPos destInventory, Function<Float, PipeItem> itemSupplier) {
        if (!this.isNode(startPipePos) || !this.isNode(destPipePos)) {
            return false;
        }
        if (!this.world.func_175667_e(startPipePos) || !this.world.func_175667_e(destPipePos)) {
            return false;
        }
        PipeTileEntity startPipe = this.getPipe(startPipePos);
        if (startPipe == null) {
            return false;
        }
        this.startProfile("get_path");
        GraphPath<BlockPos, NetworkEdge> path = this.dijkstra.getPath(startPipePos, destPipePos);
        this.endProfile();
        if (path == null) {
            return false;
        }
        PipeItem item = itemSupplier.apply(Float.valueOf(startPipe.getItemSpeed()));
        item.setDestination(startInventory, destInventory, path);
        if (!startPipe.getItems().contains(item)) {
            startPipe.getItems().add(item);
        }
        PacketHandler.sendToAllLoaded(this.world, startPipePos, new PacketItemEnterPipe(startPipePos, item));
        return true;
    }

    public ItemStack requestItem(BlockPos destPipe, BlockPos destInventory, ItemStack stack, ItemEqualityType ... equalityTypes) {
        NetworkLocation location;
        List<NetworkLocation> locations = this.getOrderedNetworkItems(destPipe);
        if (locations.isEmpty()) {
            return stack;
        }
        ItemStack remain = stack.func_77946_l();
        Iterator<NetworkLocation> iterator = locations.iterator();
        while (iterator.hasNext() && !(remain = this.requestItem(location = iterator.next(), destPipe, destInventory, remain, equalityTypes)).func_190926_b()) {
        }
        return remain;
    }

    public ItemStack requestItem(NetworkLocation location, BlockPos destPipe, BlockPos destInventory, ItemStack stack, ItemEqualityType ... equalityTypes) {
        if (location.getPos().equals((Object)destInventory)) {
            return stack;
        }
        ItemStack remain = stack.func_77946_l();
        for (int slot : location.getStackSlots(this.world, stack, equalityTypes)) {
            IItemHandler handler = location.getItemHandler(this.world);
            ItemStack extracted = handler.extractItem(slot, remain.func_190916_E(), true);
            if (!this.routeItemToLocation(location.pipePos, location.getPos(), destPipe, destInventory, speed -> new PipeItem(extracted, speed.floatValue()))) continue;
            handler.extractItem(slot, extracted.func_190916_E(), false);
            remain.func_190918_g(extracted.func_190916_E());
            if (!remain.func_190926_b()) continue;
            break;
        }
        return remain;
    }

    public PipeTileEntity getPipe(BlockPos pos) {
        PipeTileEntity tile = this.tileCache.get(pos);
        if (tile == null || tile.func_145837_r()) {
            tile = Utility.getTileEntity(PipeTileEntity.class, this.world, pos);
            this.tileCache.put(pos, tile);
        }
        return tile;
    }

    public List<NetworkLocation> getOrderedNetworkItems(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        this.startProfile("get_network_items");
        ArrayList<NetworkLocation> info = new ArrayList<NetworkLocation>();
        for (BlockPos dest : this.getOrderedNetworkNodes(node)) {
            PipeTileEntity pipe;
            if (!this.world.func_175667_e(dest) || !(pipe = this.getPipe(dest)).canNetworkSee()) continue;
            for (Direction dir : Direction.values()) {
                NetworkLocation location;
                IItemHandler handler = pipe.getItemHandler(dir, null);
                if (handler == null || info.stream().anyMatch(l -> l.getItemHandler(this.world) == handler) || (location = new NetworkLocation(dest, dir)).isEmpty(this.world)) continue;
                info.add(location);
            }
        }
        this.endProfile();
        return info;
    }

    public void createNetworkLock(NetworkLock lock) {
        this.networkLocks.put((Object)lock.location.getPos(), (Object)lock);
    }

    public void resolveNetworkLock(NetworkLock lock) {
        this.networkLocks.remove((Object)lock.location.getPos(), (Object)lock);
    }

    public List<NetworkLock> getNetworkLocks(BlockPos pos) {
        return this.networkLocks.get((Object)pos);
    }

    public int getLockedAmount(BlockPos pos, ItemStack stack, ItemEqualityType ... equalityTypes) {
        return this.getNetworkLocks(pos).stream().filter(l -> ItemEqualityType.compareItems(l.stack, stack, equalityTypes)).mapToInt(l -> l.stack.func_190916_E()).sum();
    }

    private void refreshNode(BlockPos pos, BlockState state) {
        this.startProfile("refresh_node");
        this.graph.removeAllEdges(new ArrayList(this.graph.edgesOf(pos)));
        for (NetworkEdge edge : this.createAllEdges(pos, state, false)) {
            this.addEdge(edge);
        }
        this.endProfile();
    }

    private void addEdge(NetworkEdge edge) {
        this.graph.addEdge(edge.getStartPipe(), edge.getEndPipe(), edge);
        this.graph.setEdgeWeight(edge, edge.pipes.size() - 1);
    }

    public BlockPos getNodeFromPipe(BlockPos pos) {
        if (this.isNode(pos)) {
            return pos;
        }
        BlockState state = this.world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof PipeBlock)) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            NetworkEdge edge = this.createEdge(pos, state, dir, false);
            if (edge == null) continue;
            return edge.getEndPipe();
        }
        return null;
    }

    private List<NetworkEdge> createAllEdges(BlockPos pos, BlockState state, boolean ignoreCurrBlocked) {
        this.startProfile("create_all_edges");
        ArrayList<NetworkEdge> edges = new ArrayList<NetworkEdge>();
        for (Direction dir : Direction.values()) {
            NetworkEdge edge = this.createEdge(pos, state, dir, ignoreCurrBlocked);
            if (edge == null) continue;
            edges.add(edge);
        }
        this.endProfile();
        return edges;
    }

    private NetworkEdge createEdge(BlockPos pos, BlockState state, Direction dir, boolean ignoreCurrBlocked) {
        boolean found;
        if (!ignoreCurrBlocked && !((ConnectionType)((Object)state.func_177229_b((IProperty)PipeBlock.DIRECTIONS.get(dir)))).isConnected()) {
            return null;
        }
        BlockPos currPos = pos.func_177972_a(dir);
        BlockState currState = this.world.func_180495_p(currPos);
        if (!(currState.func_177230_c() instanceof PipeBlock)) {
            return null;
        }
        this.startProfile("create_edge");
        NetworkEdge edge = new NetworkEdge();
        edge.pipes.add(pos);
        edge.pipes.add(currPos);
        block0: do {
            if (this.isNode(currPos)) {
                this.endProfile();
                return edge;
            }
            found = false;
            for (Direction nextDir : Direction.values()) {
                BlockPos offset;
                BlockState offState;
                if (!((ConnectionType)((Object)currState.func_177229_b((IProperty)PipeBlock.DIRECTIONS.get(nextDir)))).isConnected() || !((offState = this.world.func_180495_p(offset = currPos.func_177972_a(nextDir))).func_177230_c() instanceof PipeBlock) || edge.pipes.contains(offset)) continue;
                edge.pipes.add(offset);
                currPos = offset;
                currState = offState;
                found = true;
                continue block0;
            }
        } while (found);
        this.endProfile();
        return null;
    }

    private List<BlockPos> getOrderedNetworkNodes(BlockPos node) {
        List<Object> ret = this.nodeToConnectedNodes.get(node);
        if (ret == null) {
            this.startProfile("compile_connected_nodes");
            ShortestPathAlgorithm.SingleSourcePaths<BlockPos, NetworkEdge> paths = this.dijkstra.getPaths(node);
            ret = Streams.stream(new BreadthFirstIterator<BlockPos, NetworkEdge>(this.graph, node)).sorted(Comparator.comparingInt(p -> this.getPipe((BlockPos)p).getPriority()).reversed().thenComparing(paths::getWeight)).collect(Collectors.toList());
            this.nodeToConnectedNodes.put(node, ret);
            this.endProfile();
        }
        return ret;
    }

    public void clearDestinationCache(BlockPos ... nodes) {
        this.startProfile("clear_node_cache");
        for (BlockPos node : nodes) {
            this.nodeToConnectedNodes.keySet().remove(node);
        }
        this.nodeToConnectedNodes.values().removeIf(cached -> Arrays.stream(nodes).anyMatch(cached::contains));
        this.endProfile();
    }

    public List<PipeItem> getItemsInPipe(BlockPos pos) {
        return this.pipeItems.get((Object)pos);
    }

    private Stream<PipeItem> getPipeItemsOnTheWay(BlockPos goalInv) {
        this.startProfile("get_pipe_items_on_the_way");
        Stream<PipeItem> ret = this.pipeItems.values().stream().filter(i -> i.getDestInventory().equals((Object)goalInv));
        this.endProfile();
        return ret;
    }

    public int getItemsOnTheWay(BlockPos goalInv, ItemStack type, ItemEqualityType ... equalityTypes) {
        return this.getPipeItemsOnTheWay(goalInv).filter(i -> type == null || ItemEqualityType.compareItems(i.stack, type, equalityTypes)).mapToInt(i -> i.stack.func_190916_E()).sum();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<BlockPos, NetworkEdge> e) {
        this.clearDestinationCache(e.getEdgeSource(), e.getEdgeTarget());
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<BlockPos, NetworkEdge> e) {
        this.clearDestinationCache(e.getEdgeSource(), e.getEdgeTarget());
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<BlockPos> e) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<BlockPos> e) {
    }

    public void startProfile(String name) {
        this.world.func_217381_Z().func_194340_a(() -> "prettypipes:pipe_network_" + name);
    }

    public void endProfile() {
        this.world.func_217381_Z().func_76319_b();
    }

    public static PipeNetwork get(World world) {
        return (PipeNetwork)world.getCapability(Registry.pipeNetworkCapability).orElse(null);
    }
}

