/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.compat.jei.CraftingTerminalTransferHandler;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@JeiPlugin
public class JEIPrettyPipesPlugin
implements IModPlugin {
    private IJeiRuntime runtime;
    private String lastTerminalText;
    private String lastJeiText;
    private Button jeiSyncButton;

    public JEIPrettyPipesPlugin() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("prettypipes", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTerminalTransferHandler(), VanillaRecipeCategoryUid.CRAFTING);
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        this.jeiSyncButton = new Button(terminal.getGuiLeft() - 22, terminal.getGuiTop() + 44, 20, 20, "", button -> {
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.syncJei = !prefs.syncJei;
            prefs.save();
            terminal.updateWidgets();
        });
        event.addWidget((Widget)this.jeiSyncButton);
        if (PlayerPrefs.get().syncJei) {
            terminal.search.func_146180_a(this.runtime.getIngredientFilter().getFilterText());
        }
    }

    @SubscribeEvent
    public void onRenderGui(GuiScreenEvent.DrawScreenEvent event) {
        Screen screen = event.getGui();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        boolean sync = PlayerPrefs.get().syncJei;
        if (event instanceof GuiScreenEvent.DrawScreenEvent.Post) {
            if (this.jeiSyncButton.isHovered()) {
                terminal.renderTooltip(I18n.func_135052_a((String)("info.prettypipes.sync_jei." + (sync ? "on" : "off")), (Object[])new Object[0]), event.getMouseX(), event.getMouseY());
            }
        } else if (event instanceof GuiScreenEvent.DrawScreenEvent.Pre) {
            this.jeiSyncButton.setMessage((sync ? TextFormatting.GREEN : TextFormatting.RED) + "J");
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!PlayerPrefs.get().syncJei) {
            return;
        }
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof ItemTerminalGui)) {
            this.lastTerminalText = null;
            this.lastJeiText = null;
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        IIngredientFilter filter = this.runtime.getIngredientFilter();
        String terminalText = terminal.search.func_146179_b();
        String jeiText = filter.getFilterText();
        if (!jeiText.equals(this.lastJeiText)) {
            this.lastTerminalText = jeiText;
            this.lastJeiText = jeiText;
            terminal.search.func_146180_a(jeiText);
        } else if (!terminalText.equals(this.lastTerminalText)) {
            this.lastTerminalText = terminalText;
            this.lastJeiText = terminalText;
            filter.setFilterText(terminalText);
        }
    }
}

