/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import stepsword.mahoutsukai.render.ClipWrappedRenderLayer;
import stepsword.mahoutsukai.render.ClippedRenderTypeBuffer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderUtils {
    public static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    public static final ResourceLocation runes = new ResourceLocation("mahoutsukai:textures/block/runes.png");

    public static void rotateQ(float w, float x, float y, float z, MatrixStack matrix) {
        matrix.func_227863_a_(new Quaternion(new Vector3f(x, y, z), w, true));
    }

    public static RenderType renderRing(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        RenderType type = MahoujinRenderType.createRunesRenderType(runes, ring_index);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRing(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        IVertexBuilder bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
                bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(texx, 0.0f).func_225587_b_(lx, ly).func_181675_d();
            bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(texx, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        }
        matrix.func_227865_b_();
        return type;
    }

    public static void translateBasic(double x, double y, double z) {
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d basic = renderInfo.func_216785_c();
        GlStateManager.func_227689_c_((float)renderInfo.func_216777_e(), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227689_c_((float)(renderInfo.func_216778_f() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_227670_b_((double)(x - basic.field_72450_a), (double)(y - basic.field_72448_b), (double)(z - basic.field_72449_c));
    }

    public static void fixTranslucent() {
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d basic = renderInfo.func_216785_c();
        Tessellator.func_178181_a().func_178180_c().func_181674_a((float)basic.field_72450_a, (float)basic.field_72448_b, (float)basic.field_72449_c);
    }

    public static void bindTexture(ResourceLocation r) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
    }

    public static void renderClippedItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn, float progress, double x, double y, double z, double yaw, double pitch, boolean clip) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag1;
            matrixStackIn.func_227860_a_();
            boolean flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI;
            boolean bl = flag1 = flag || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag1) {
                modelIn = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)leftHand);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag1)) {
                RenderType rendertype = RenderTypeLookup.func_228389_a_((ItemStack)itemStackIn);
                RenderType rendertype1 = flag && Objects.equals(rendertype, Atlases.func_228784_i_()) ? Atlases.func_228785_j_() : rendertype;
                rendertype1 = new ClipWrappedRenderLayer(clip, pitch, yaw, x, y, z, progress, rendertype1);
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype1);
                RenderUtils.renderModel(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_228364_a_(itemStackIn, matrixStackIn, (IRenderTypeBuffer)new ClippedRenderTypeBuffer(bufferIn, clip, pitch, yaw, x, y, z, progress), combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private static void renderModel(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public static IVertexBuilder getBuffer(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        return glintIn ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(isItemIn ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn)) : bufferIn.getBuffer(renderTypeIn);
    }

    public static Vec3d vecFromPitchYaw(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static void renderFSQ(MatrixStack stack, ResourceLocation texture, float r1, float g1, float b1, float a1, float xoffset, float yoffset, float x, float y, float z) {
        float r = r1 / 255.0f;
        float g = g1 / 255.0f;
        float b = b1 / 255.0f;
        float a = a1;
        Matrix4f m = stack.func_227866_c_().func_227870_a_();
        Entity e = Minecraft.func_71410_x().func_175606_aa();
        if (e != null) {
            int j = 240;
            int k = 240;
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            RenderType type = MahoujinRenderType.createMahoujinRenderType(texture, 0, false);
            IVertexBuilder bb = Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(type);
            bb.func_227888_a_(m, 0.0f + xoffset, 0.0f + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(j, k).func_181675_d();
            bb.func_227888_a_(m, 0.0f + xoffset, y + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(j, k).func_181675_d();
            bb.func_227888_a_(m, x + xoffset, y + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(j, k).func_181675_d();
            bb.func_227888_a_(m, x + xoffset, 0.0f + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(j, k).func_181675_d();
            buffer.func_228462_a_(type);
        }
    }

    public static void renderTextureOverlay(MatrixStack matrix, String loc, int r, int g, int b, float a, float xoffset, float yoffset, float x, float y, float z) {
        ResourceLocation rl = new ResourceLocation(loc);
        RenderUtils.renderFSQ(matrix, rl, r, g, b, a, xoffset, yoffset, x, y, z);
    }

    public static float calculateOverlayFade(int duration, int interval, int fadeTicks, float maxAlpha) {
        int large = duration % interval;
        float alpha = 0.0f;
        if (large > interval - fadeTicks) {
            alpha = ((float)large - ((float)interval - (float)fadeTicks)) / (float)fadeTicks;
            alpha *= maxAlpha;
        }
        return alpha;
    }

    public static void renderSphere(MatrixStack matrix, IRenderTypeBuffer buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        float PI = 3.141592f;
        IVertexBuilder bb = buf.getBuffer(type);
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        for (float alpha = 0.0f; alpha < 3.141592f; alpha += 3.141592f / (float)gradation) {
            float beta = 0.0f;
            while ((double)beta < 6.31459997177124) {
                float x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha));
                float y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha));
                float z = (float)((double)radius * Math.cos(alpha));
                bb.func_227888_a_(m, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
                x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                z = (float)((double)radius * Math.cos(alpha + 3.141592f / (float)gradation));
                bb.func_227888_a_(m, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
                beta += 3.141592f / (float)gradation;
            }
        }
    }
}

