/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.proxy;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.item.guide.ContentsPage;
import stepsword.mahoutsukai.item.guide.GuidebookInstance;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.render.gui.MahoujinProjectorScreen;
import stepsword.mahoutsukai.render.gui.WheelGui;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ClientProxy
extends CommonProxy {
    boolean sensechanged = false;
    double oldsense;
    static Field entities;

    @Override
    public void openProjectorGUI(World w, BlockPos p) {
        Minecraft.func_71410_x().func_147108_a((Screen)new MahoujinProjectorScreen(w, p));
    }

    @Override
    public void openWheelGUI(World w, ItemStack s) {
        Minecraft.func_71410_x().func_147108_a((Screen)new WheelGui(w, s));
    }

    @Override
    public void init() {
        ClientHandler client = new ClientHandler();
        MinecraftForge.EVENT_BUS.register((Object)client);
        MahouTsukaiMod.MOD_EVENT_BUS.register((Object)client);
        super.init();
    }

    @Override
    public boolean handleMaterialAcceleration(Entity entityIn) {
        return false;
    }

    @Override
    public PlayerEntity getPlayerForScry(World world, String viewTarget, CompoundNBT scryNBT, UUID uuid) {
        PlayerEntity playertarget = ScryingMahoujinTileEntity.getPlayerByName(viewTarget, world);
        if (playertarget == null && uuid != null) {
            RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, new GameProfile(uuid, viewTarget));
            player.func_70020_e(scryNBT);
            return player;
        }
        if (playertarget != null && scryNBT != null) {
            RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, playertarget.func_146103_bH());
            player.func_70020_e(scryNBT);
            return player;
        }
        return null;
    }

    @Override
    public void revertPlayer() {
        super.revertPlayer();
        Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
    }

    public static HashSet<Entity> getAllEntities(ClientWorld world) {
        if (entities == null) {
            try {
                entities = ObfuscationReflectionHelper.findField(ClientWorld.class, (String)"entitiesById");
            }
            catch (Exception e) {
                entities = ObfuscationReflectionHelper.findField(ClientWorld.class, (String)"field_217429_b");
            }
        }
        try {
            entities.setAccessible(true);
            Int2ObjectMap set = (Int2ObjectMap)entities.get(world);
            return new HashSet<Entity>((Collection<Entity>)set.values());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void openGuideGUI(GuidebookInstance book, PlayerEntity playerIn) {
        if (book.getPage() instanceof ContentsPage) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ContentsPageGui(book, (ContentsPage)book.getPage()));
        }
    }

    @Override
    public void slowDown() {
        if (!this.sensechanged) {
            this.oldsense = Minecraft.func_71410_x().field_71474_y.field_74341_c;
            Minecraft.func_71410_x().field_71474_y.field_74341_c *= (double)0.34f;
            this.sensechanged = true;
        }
    }

    @Override
    public void speedUp() {
        if (this.sensechanged) {
            Minecraft.func_71410_x().field_71474_y.field_74341_c = this.oldsense;
            this.sensechanged = false;
        }
    }

    @Override
    public boolean isMahouTsukai() {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        if (mahou != null) {
            return mahou.hasMagic();
        }
        return false;
    }

    @Override
    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.playSound(x, y, z, soundIn, category, volume, pitch, false);
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        double d0 = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_186679_c(x, y, z);
        SimpleSound simplesound = new SimpleSound(soundIn, category, volume, pitch, (float)x, (float)y, (float)z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)simplesound);
        }
    }
}

