/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class BindingEyesPotion
extends EyesPotion {
    protected BindingEyesPotion() {
        super(ModEffects.getColorNumber(252, 45, 225));
    }

    public static void bindingEyesPlayerTick(PlayerEntity player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.BINDING_EYES)) {
            BindingEyesPotion.addBindings(player);
        }
        if (BindingEyesPotion.isBound((LivingEntity)player) && !BindingEyesPotion.continueBinding((LivingEntity)player)) {
            EffectUtil.debuff((LivingEntity)player, ModEffects.BOUND);
        }
    }

    public static boolean bindingEyesLivingUpdate(LivingEntity entity) {
        boolean ret = false;
        World world = entity.field_70170_p;
        if (EffectUtil.hasBuff(entity, ModEffects.BOUND)) {
            entity.field_82175_bq = false;
            if (!world.field_72995_K) {
                if (!(entity instanceof PlayerEntity)) {
                    ret = true;
                }
                --entity.field_70172_ad;
                if (!BindingEyesPotion.continueBinding(entity)) {
                    EffectUtil.debuff(entity, ModEffects.BOUND);
                }
            }
        }
        return ret;
    }

    public static void addBindings(PlayerEntity player) {
        int totalRange = MTConfig.MYSTIC_EYES_RANGE_FROM_USER;
        Vec3d myloc = player.func_213303_ch();
        List lst = player.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(myloc.field_72450_a - (double)totalRange, myloc.field_72448_b - (double)totalRange, myloc.field_72449_c - (double)totalRange, myloc.field_72450_a + (double)totalRange, myloc.field_72448_b + (double)totalRange, myloc.field_72449_c + (double)totalRange));
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, (LivingEntity)player, myloc, MTConfig.MYSTIC_EYES_RANGE_FROM_LOOK_VEC, true) || ContractMahoujinTileEntity.isImmuneToSpell(player.field_70170_p, player.func_110124_au(), (Entity)tmp) || BindingEyesPotion.isBound(tmp)) continue;
            EffectUtil.buff(tmp, ModEffects.BOUND, false, 100);
        }
    }

    public static boolean continueBinding(LivingEntity victim) {
        int totalRange = MTConfig.MYSTIC_EYES_RANGE_FROM_USER;
        Vec3d myloc = victim.func_213303_ch();
        boolean keepBinding = false;
        List lst = victim.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(myloc.field_72450_a - (double)totalRange, myloc.field_72448_b - (double)totalRange, myloc.field_72449_c - (double)totalRange, myloc.field_72450_a + (double)totalRange, myloc.field_72448_b + (double)totalRange, myloc.field_72449_c + (double)totalRange));
        for (PlayerEntity tmp : lst) {
            if (tmp.func_110124_au().equals(victim.func_110124_au()) || !EffectUtil.hasBuff((LivingEntity)tmp, ModEffects.BINDING_EYES) || !EffectUtil.inRange(victim, (LivingEntity)tmp, myloc, MTConfig.MYSTIC_EYES_RANGE_FROM_LOOK_VEC, true)) continue;
            keepBinding = true;
        }
        return keepBinding;
    }

    public static boolean isBound(LivingEntity e) {
        return EffectUtil.hasBuff(e, ModEffects.BOUND);
    }
}

