/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.TreasuryProjection;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.render.item.TreasuryProjectionGauntletRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TreasuryProjectionGauntlet
extends ItemBase {
    public TreasuryProjectionGauntlet() {
        super("treasury_projection_gauntlet", new Item.Properties().setISTER(() -> TreasuryProjectionGauntletRenderer::new));
        this.addPropertyOverrides();
    }

    public void addPropertyOverrides() {
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof TreasuryProjectionGauntlet) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof PlayerEntity && !player.field_70170_p.field_72995_K) {
            int mana = MTConfig.TREASURY_PROJECTION_GAUNTLET_MANA_COST;
            int cooldown = MTConfig.TREASURY_PROJECTION_COOLDOWN;
            if (count % cooldown == 0 && PlayerManaManager.drainMana((PlayerEntity)player, mana, false, false) == mana) {
                ItemStack stack2;
                int j;
                int z;
                IItemHandler inv;
                ItemStack stack1;
                int i;
                Vec3d v = this.findSpotToCast(player.field_70170_p, player);
                Random random = player.func_70681_au();
                int size = ((PlayerEntity)player).field_71071_by.field_70462_a.size();
                ArrayList<ItemStack> projectables = new ArrayList<ItemStack>();
                for (i = 0; i < size; ++i) {
                    stack1 = (ItemStack)((PlayerEntity)player).field_71071_by.field_70462_a.get(i);
                    if (this.isArrow(stack1)) {
                        projectables.add(stack1);
                    }
                    if ((inv = Utils.getInventory(stack1)) == null) continue;
                    z = inv.getSlots();
                    for (j = 0; j < z; ++j) {
                        stack2 = inv.getStackInSlot(j);
                        if (!this.isArrow(stack2)) continue;
                        projectables.add(stack2);
                    }
                }
                for (i = 0; i < ((PlayerEntity)player).func_71005_bN().func_70302_i_(); ++i) {
                    stack1 = ((PlayerEntity)player).func_71005_bN().func_70301_a(i);
                    if (this.isArrow(stack1)) {
                        projectables.add(stack1);
                    }
                    if ((inv = Utils.getInventory(stack1)) == null) continue;
                    z = inv.getSlots();
                    for (j = 0; j < z; ++j) {
                        stack2 = inv.getStackInSlot(j);
                        if (!this.isArrow(stack2)) continue;
                        projectables.add(stack2);
                    }
                }
                if (projectables.size() > 0) {
                    ItemStack projectile = (ItemStack)projectables.get(random.nextInt(projectables.size()));
                    TreasuryProjectionGauntlet.shootWeaponAt(projectile, player.field_70170_p, v, player, random);
                }
            }
        }
        super.onUsingTick(stack, player, count);
    }

    protected boolean isArrow(ItemStack stack) {
        int i;
        boolean sword;
        Item tmpi = stack.func_77973_b();
        if (stack.func_190926_b()) {
            return false;
        }
        List<? extends String> white = MTConfig.TREASURY_PROJECTION_WHITELIST;
        List<? extends String> black = MTConfig.TREASURY_PROJECTION_BLACKLIST;
        boolean allow_all = MTConfig.TREASURY_PROJECTION_ALLOW_ALL;
        boolean deny_all = MTConfig.TREASURY_PROJECTION_DENY_ALL;
        boolean bl = sword = tmpi instanceof SwordItem || tmpi instanceof ToolItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof HoeItem;
        if (deny_all) {
            sword = false;
        }
        boolean inwhite = false;
        boolean inblack = false;
        for (i = 0; i < white.size(); ++i) {
            if (tmpi.getRegistryName() == null || !white.get(i).equals(tmpi.getRegistryName().toString())) continue;
            inwhite = true;
            break;
        }
        for (i = 0; i < black.size(); ++i) {
            if (tmpi.getRegistryName() == null || !black.get(i).equals(tmpi.getRegistryName().toString())) continue;
            inblack = true;
            break;
        }
        if (inblack) {
            return false;
        }
        return sword || inwhite || allow_all;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BLOCK;
    }

    public Vec3d findSpotToCast(World world, LivingEntity player) {
        Entity e = ProjectionSpellEffect.playerLook(player, MTConfig.GLOBAL_LOOK_RANGE, world, null);
        Vec3d v = e instanceof LivingEntity ? e.func_213303_ch() : this.getTargetBlock(player);
        return v;
    }

    public Vec3d getTargetBlock(LivingEntity player) {
        Vec3d target;
        RayTraceResult result = Utils.rayTraceEyes(player, MTConfig.GLOBAL_LOOK_RANGE);
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult br = (BlockRayTraceResult)result;
            target = new Vec3d((double)br.func_216350_a().func_177958_n() + 0.5, (double)br.func_216350_a().func_177956_o(), (double)br.func_216350_a().func_177952_p() + 0.5);
        } else {
            Vec3d v = player.func_70676_i(0.0f);
            Vec3d v2 = new Vec3d(v.field_72450_a * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72448_b * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72449_c * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3d v3 = player.func_174824_e(1.0f).func_178787_e(v2);
            while (Utils.isBlockAir(player.field_70170_p, new BlockPos(v3)) && v3.field_72448_b > 0.0) {
                v3 = v3.func_178787_e(new Vec3d(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public static void shootWeaponAt(ItemStack stack, World world, Vec3d pos, LivingEntity player, Random random) {
        GateWeaponProjectileEntity weapon;
        int d = MTConfig.TREASURY_PROJECTION_DISTANCE;
        int d2 = MTConfig.TREASURY_PROJECTION_MIN_DISTANCE;
        int tries = 0;
        do {
            ++tries;
            int circleDegrees = random.nextInt(360);
            int groundDegrees = random.nextInt(70) + 20;
            int distance = random.nextInt(d2) + (d - d2);
            double height = (double)distance * Math.cos(EffectUtil.toRad(groundDegrees));
            double radius = Math.sqrt((double)(distance * distance) - height * height);
            double zplus = radius * Math.sin(EffectUtil.toRad(circleDegrees));
            double xplus = -radius * Math.cos(EffectUtil.toRad(circleDegrees));
            weapon = new GateWeaponProjectileEntity(world, pos.field_72450_a + xplus, pos.field_72448_b + height, pos.field_72449_c + zplus, stack.func_77946_l(), (Entity)player);
            weapon.field_70125_A = groundDegrees;
            weapon.field_70177_z = circleDegrees - 90;
            Vec3d aim = weapon.func_213303_ch().func_178788_d(pos);
            weapon.func_70186_c(-aim.field_72450_a, -aim.field_72448_b, -aim.field_72449_c, 3.0f, 4.0f);
        } while (!world.func_175623_d(weapon.func_180425_c()) && tries < 20);
        world.func_217376_c((Entity)weapon);
    }
}

