/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.SpatialDisorientation;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.mahoujin.SpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.util.Utils;

public class SpatialDisorientationStaff
extends ItemBase {
    private LivingEntity target = null;
    private SpatialDisorientationMahoujinEntity mahoujin = null;
    private Vec3d location = null;
    boolean firstBounce = false;

    public SpatialDisorientationStaff() {
        super("spatial_disorientation_staff", ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1, 20);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof SpatialDisorientationStaff) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        float r = 1.0f;
        float g = 0.7372549f;
        float b = 0.12941177f;
        float a = 0.95f;
        if (this.target != null) {
            this.target.func_213293_j(0.0, 0.0, 0.0);
            if (!player.field_70170_p.field_72995_K) {
                if (this.mahoujin == null) {
                    if (PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.SPATIAL_DISORIENTATION_MANA_COST_ST, false, false) == MTConfig.SPATIAL_DISORIENTATION_MANA_COST_ST) {
                        SpatialDisorientationMahoujinEntity m = new SpatialDisorientationMahoujinEntity(player.field_70170_p, (PlayerEntity)player, r, g, b, a);
                        m.sizer(this.target.func_213311_cf() * 2.0f);
                        m.setRotationSpeed(0.25f);
                        this.mahoujin = m;
                        this.reangle((PlayerEntity)player, this.target.func_213303_ch(), 2.125f);
                        this.target.field_70170_p.func_217376_c((Entity)m);
                    }
                } else if (this.mahoujin.getRotationSpeed() < 8.0f) {
                    this.mahoujin.setRotationSpeed(this.mahoujin.getRotationSpeed() + 0.1f);
                }
                this.reangle((PlayerEntity)player, this.target.func_213303_ch(), 2.125f);
            }
        } else if (this.location != null) {
            if (!player.field_70170_p.field_72995_K) {
                if (this.mahoujin == null) {
                    if (PlayerManaManager.hasMana((PlayerEntity)player, MTConfig.SPATIAL_DISORIENTATION_MANA_COST_AOE * 10)) {
                        SpatialDisorientationMahoujinEntity m = new SpatialDisorientationMahoujinEntity(player.field_70170_p, (PlayerEntity)player, r, g, b, a);
                        m.sizer(3.5f);
                        m.setRotationSpeed(0.25f);
                        this.mahoujin = m;
                        this.reangle((PlayerEntity)player, this.location, 2.125f);
                        player.field_70170_p.func_217376_c((Entity)m);
                    }
                } else {
                    if (this.mahoujin.getRotationSpeed() < 8.0f) {
                        this.mahoujin.setRotationSpeed(this.mahoujin.getRotationSpeed() + 0.1f);
                    }
                    this.reangle((PlayerEntity)player, this.location, 2.125f);
                }
                if (count % 20 == 0 && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.SPATIAL_DISORIENTATION_MANA_COST_AOE, false, false) == MTConfig.SPATIAL_DISORIENTATION_MANA_COST_AOE) {
                    PlayerManaManager.updateClientMahou((ServerPlayerEntity)player, Utils.getPlayerMahou(player));
                } else if (count % 20 == 0) {
                    player.func_184597_cx();
                }
            }
            if (this.mahoujin != null && this.mahoujin.getRotationSpeed() >= 8.0f && count % 4 == 0) {
                List entities = this.mahoujin.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(this.location.field_72450_a - 4.0, this.location.field_72448_b - 4.0, this.location.field_72449_c - 4.0, this.location.field_72450_a + 4.0, this.location.field_72448_b + 4.0, this.location.field_72449_c + 4.0), null);
                for (Entity tmp : entities) {
                    Vec3d vec = Vec3d.func_189986_a((float)player.field_70125_A, (float)player.field_70177_z);
                    float speed = this.mahoujin.getRotationSpeed() * 1.2f;
                    if (tmp instanceof PlayerEntity) {
                        speed *= 4.0f;
                    }
                    this.boop(tmp, speed, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            }
        }
    }

    private void reangle(PlayerEntity player, Vec3d target, float distance) {
        if (this.mahoujin != null && player != null && target != null) {
            this.mahoujin.angleCircleAroundBlock(90.0f - player.field_70177_z, player.field_70125_A + 90.0f, distance, new Vec3d(target.field_72450_a, target.field_72448_b, target.field_72449_c));
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        Vec3d motion = entity.func_213322_ci();
        double motionX = motion.field_72450_a;
        double motionY = motion.field_72448_b;
        double motionZ = motion.field_72449_c;
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX = x / (double)f * (double)strength;
        motionZ = z / (double)f * (double)strength;
        motionY = y / (double)f * (double)strength;
        entity.func_213293_j(motionX, motionY, motionZ);
        entity.field_70133_I = true;
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.func_77626_a(stack) - charge;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Entity t = ProjectionSpellEffect.playerLook((LivingEntity)player, MTConfig.GLOBAL_LOOK_RANGE, world, SpatialDisorientationStaff.getProjectionLookPredicate());
        if (t instanceof LivingEntity) {
            this.target = (LivingEntity)t;
            this.location = null;
        } else {
            this.target = null;
            RayTraceResult result = player.func_213324_a((double)MTConfig.GLOBAL_LOOK_RANGE, 0.0f, false);
            this.location = !(result instanceof BlockRayTraceResult) ? player.func_70040_Z().func_72432_b().func_186678_a(10.0).func_178787_e(player.func_174824_e(1.0f)) : new Vec3d((double)((BlockRayTraceResult)result).func_216350_a().func_177958_n() + 0.5, (double)(((BlockRayTraceResult)result).func_216350_a().func_177956_o() + 5), (double)((BlockRayTraceResult)result).func_216350_a().func_177952_p() + 0.5);
        }
        player.func_184598_c(hand);
        this.firstBounce = true;
        this.mahoujin = null;
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        if (this.mahoujin != null) {
            if (this.target != null) {
                LivingEntity player = entityLiving;
                Vec3d vec = Vec3d.func_189986_a((float)player.field_70125_A, (float)player.field_70177_z);
                if (!this.target.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity && this.target instanceof PigEntity && ((PigEntity)this.target).func_184188_bt().contains(player)) {
                    ModTriggers.FLYING_PIGS.trigger((ServerPlayerEntity)player);
                }
                this.boop((Entity)this.target, this.mahoujin.getRotationSpeed() * 1.2f, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            this.mahoujin.func_70106_y();
        }
    }

    public static Predicate<Entity> getProjectionLookPredicate() {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity e) {
                return e instanceof LivingEntity;
            }
        };
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.NONE;
    }
}

