/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.util.EffectUtil;

public class RhoAiasMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_LOOK_VEC = "MAHOUTSUKAI_LOOK_VEC";
    public static final int loadUpTime = 20;
    float sphereMidRadius = 7.0f;
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final DataParameter<Float> ROTATION_YAW = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_ROLL = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_PITCH = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_SPEED = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CIRCLE_SIZE = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<CompoundNBT> LOOK_VEC = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Float> DISTANCE = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(RhoAiasMahoujinEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public UUID casterUUID = null;
    public static final String entityName = "rho_aias_mahoujin_entity";

    public RhoAiasMahoujinEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public RhoAiasMahoujinEntity(World world) {
        super(ModEntities.RHO_AIAS, world);
        this.field_70158_ak = true;
    }

    public RhoAiasMahoujinEntity(World world, PlayerEntity caster) {
        this(world);
        this.casterUUID = caster.func_110124_au();
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(this.casterUUID));
    }

    public RhoAiasMahoujinEntity(World world, PlayerEntity caster, float r, float g, float b, float a, float size) {
        this(world);
        this.casterUUID = caster.func_110124_au();
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(this.casterUUID));
        this.setColor(r, g, b, a);
        this.angleForPlayer(caster);
        this.sizer(size);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DISTANCE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_VEC, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(0.0, 0.0, 0.0);
        try {
            if (this.casterUUID == null) {
                this.casterUUID = (UUID)((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.field_70126_B = this.field_70177_z;
        if (this.field_70126_B < 0.0f) {
            this.field_70126_B += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.field_70177_z = this.getRotationYaw();
        this.field_70125_A = this.getRotationPitch();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (!this.field_70170_p.field_72995_K) {
            this.setLife(this.getLife() + 1);
            if (this.casterUUID == null) {
                this.func_70106_y();
            } else {
                PlayerEntity caster = this.field_70170_p.func_217371_b(this.casterUUID);
                if (caster == null || !caster.func_70089_S()) {
                    this.func_70106_y();
                }
            }
            if (this.getLife() >= 1200) {
                this.func_70106_y();
            }
        }
        this.projectileDeletion();
        this.collideWithNearbyEntities();
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!entityIn.func_110124_au().equals(this.casterUUID)) {
            // empty if block
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void func_145775_I() {
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public void angleForPlayer(PlayerEntity user) {
        Vec3d vec = user.func_70040_Z().func_72432_b().func_186678_a(5.0);
        this.setLookV(user.func_70040_Z().func_72432_b());
        Vec3d eyes = user.func_174824_e(1.0f);
        this.func_70107_b(eyes.field_72450_a + vec.field_72450_a, eyes.field_72448_b + vec.field_72448_b, eyes.field_72449_c + vec.field_72449_c);
        double theta = Math.asin(vec.field_72448_b / 5.0);
        theta = RhoAiasMahoujinEntity.fromRad(theta);
        this.setRotationPitch((float)(90.0 - theta));
        this.setRotationRoll(360.0f - user.field_70177_z);
    }

    public static double fromRad(double rad) {
        return rad * 57.2957795131;
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void collideWithNearbyEntities() {
        float size = this.getCircleSize();
        AxisAlignedBB maabb = new AxisAlignedBB(this.func_226277_ct_() - (double)size, this.func_226278_cu_() - (double)size, this.func_226281_cx_() - (double)size, this.func_226277_ct_() + (double)size, this.func_226278_cu_() + (double)size, this.func_226281_cx_() + (double)size);
        List list = this.field_70170_p.func_175674_a((Entity)this, maabb.func_186662_g(2.0), null);
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                int collide;
                Entity entity = (Entity)list.get(l);
                try {
                    if (MTConfig.RHO_AIAS_SNEAK_BOOP && entity.func_110124_au().equals(((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).get()) && !entity.func_226273_bm_()) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((collide = this.doesItCollide(entity)) == 3 || collide == 1) {
                    this.collideWithEntity(entity);
                    continue;
                }
                if (collide != 0) continue;
            }
        }
    }

    public int doesItCollide(Entity entity) {
        AxisAlignedBB aabb = entity.func_174813_aQ();
        boolean flag = false;
        boolean flag1 = false;
        if (aabb != null) {
            Vec3d a1 = new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
            Vec3d a2 = new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f);
            Vec3d a3 = new Vec3d(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c);
            Vec3d a4 = new Vec3d(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
            Vec3d b1 = new Vec3d(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c);
            Vec3d b2 = new Vec3d(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f);
            Vec3d b3 = new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c);
            Vec3d b4 = new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            int f1 = this.whereIsPoint(a1);
            int f2 = this.whereIsPoint(a2);
            int f3 = this.whereIsPoint(a3);
            int f4 = this.whereIsPoint(a4);
            int f5 = this.whereIsPoint(b1);
            int f6 = this.whereIsPoint(b2);
            int f7 = this.whereIsPoint(b3);
            int f8 = this.whereIsPoint(b4);
            flag = f1 == 1 || f2 == 1 || f3 == 1 || f4 == 1 || f5 == 1 || f6 == 1 || f7 == 1 || f8 == 1;
            boolean bl = flag1 = f1 == 2 || f2 == 2 || f3 == 2 || f4 == 2 || f5 == 2 || f6 == 2 || f7 == 2 || f8 == 2;
        }
        if (flag && flag1) {
            return 3;
        }
        if (flag) {
            return 1;
        }
        if (flag1) {
            return 2;
        }
        return 0;
    }

    public void projectileDeletion() {
        if (!this.field_70170_p.field_72995_K) {
            int radius = MTConfig.RHO_AIAS_KILL_RANGE;
            double posX = this.func_226277_ct_();
            double posY = this.func_226278_cu_();
            double posZ = this.func_226281_cx_();
            AxisAlignedBB paabb = new AxisAlignedBB(posX - (double)radius, posY - (double)radius, posZ - (double)radius, posX + (double)radius, posY + (double)radius, posZ + (double)radius);
            List<? extends String> killList = MTConfig.RHO_AIAS_ENTITY_KILL_LIST;
            List<? extends String> collideList = MTConfig.RHO_AIAS_COLLIDE_KILL_LIST;
            if (killList.size() > 0) {
                HashSet<? extends String> set = new HashSet<String>(killList);
                HashSet<? extends String> set2 = new HashSet<String>(collideList);
                List lst = this.field_70170_p.func_217357_a(Entity.class, paabb);
                for (Entity e : lst) {
                    int z;
                    if (e instanceof PlayerEntity || e instanceof RhoAiasMahoujinEntity || e.func_200600_R().getRegistryName() == null) continue;
                    String regname = e.func_200600_R().getRegistryName().toString();
                    if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                        System.out.println("found entity near Rho Aias:" + regname);
                    }
                    if (set.contains(regname.toString())) {
                        Vec3d v = e.func_213322_ci();
                        Vec3d p = e.func_213303_ch();
                        if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                            System.out.println("found entity on kill list:" + regname + ":pos:" + p.toString() + ":vel:" + v.toString());
                        }
                        if (this.isPointInRadiusOfCircle(p.func_178787_e(v)) && !this.isPointInRadiusOfCircle(p)) {
                            e.func_70106_y();
                        }
                        if (!this.isPointInRadiusOfCircle(p.func_178787_e(v.func_186678_a(-1.0))) && this.isPointInRadiusOfCircle(p)) {
                            e.func_70106_y();
                        }
                    }
                    if (!set2.contains(regname) || (z = this.doesItCollide(e)) != 1 && z != 3) continue;
                    e.func_70106_y();
                }
            }
        }
    }

    protected void collideWithEntity(Entity entityIn) {
        if (entityIn instanceof ArrowEntity) {
            ArrowEntity arrow = (ArrowEntity)entityIn;
            if (arrow.field_70250_c == null || !arrow.field_70250_c.equals(this.casterUUID)) {
                arrow.func_70106_y();
            }
        } else if (entityIn instanceof LivingEntity && this.getLookV() != null) {
            Vec3d v = this.getLookV();
            this.boop(entityIn, 1.0f, -v.field_72450_a, -v.field_72448_b, -v.field_72449_c);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        Vec3d motion = this.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.field_70122_E) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setRotationYaw(compound.func_74760_g(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.func_74760_g(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.func_74760_g(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.func_74760_g(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.func_74760_g(TAG_CIRCLE_SIZE));
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.casterUUID = compound.func_186857_a(TAG_CASTER);
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
        this.setDistance(compound.func_74760_g(TAG_DISTANCE));
        CompoundNBT look = compound.func_74775_l(TAG_LOOK_VEC);
        this.setLookV(new Vec3d(look.func_74769_h("x"), look.func_74769_h("y"), look.func_74769_h("z")));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.func_74776_a(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.func_74776_a(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.func_74776_a(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.func_74776_a(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_186854_a(TAG_CASTER, this.casterUUID);
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
        compound.func_74776_a(TAG_DISTANCE, this.getDistance());
        Vec3d look = this.getLookV();
        CompoundNBT looknbt = new CompoundNBT();
        looknbt.func_74780_a("x", look.field_72450_a);
        looknbt.func_74780_a("y", look.field_72448_b);
        looknbt.func_74780_a("z", look.field_72449_c);
        compound.func_218657_a(TAG_LOOK_VEC, (INBT)looknbt);
    }

    public boolean isPointInRadiusOfCircle(Vec3d pos) {
        Vec3d sphereMid = this.getSphereMid();
        double distance = pos.func_72438_d(sphereMid);
        return distance < (double)this.sphereMidRadius;
    }

    public boolean isPointInShieldRectangle(Vec3d pos) {
        float width = 5.5f;
        float height = 2.0f;
        Vec3d rotatedpos = this.rotateAroundOrigin(pos, EffectUtil.toRad(-this.getRotationPitch()), EffectUtil.toRad(-this.getRotationRoll()), EffectUtil.toRad(-this.getRotationYaw()));
        Vec3d rotatedpos2 = this.rotateAroundOrigin(pos, EffectUtil.toRad(-this.getRotationPitch()), EffectUtil.toRad(-this.getRotationRoll()), EffectUtil.toRad(-this.getRotationYaw()));
        return rotatedpos.field_72450_a > this.func_226277_ct_() - (double)width && rotatedpos.field_72450_a < this.func_226277_ct_() + (double)width && rotatedpos.field_72448_b > this.func_226278_cu_() - (double)(height * 2.0f) && rotatedpos.field_72448_b < this.func_226278_cu_() + 1.0 && rotatedpos.field_72449_c > this.func_226281_cx_() - (double)width && rotatedpos.field_72449_c < this.func_226281_cx_() + (double)width;
    }

    public Vec3d getSphereMid() {
        Vec3d sphereMid = this.func_213303_ch().func_178788_d(this.getLookV().func_72432_b().func_186678_a((double)this.sphereMidRadius));
        return sphereMid;
    }

    public int whereIsPoint(Vec3d pos) {
        if (!this.isPointInShieldRectangle(pos)) {
            return 0;
        }
        if (this.isPointInRadiusOfCircle(pos)) {
            return 1;
        }
        return 2;
    }

    public Vec3d rotateAroundOrigin(Vec3d pos, float pitch, float roll, float yaw) {
        Vec3d rho = this.func_213303_ch();
        return rho.func_178787_e(pos.func_178788_d(rho).func_178785_b(roll).func_178789_a(pitch).func_178785_b(yaw));
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getRotationYaw() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.field_70180_af.func_187227_b(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.field_70180_af.func_187227_b(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.field_70180_af.func_187227_b(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.field_70180_af.func_187227_b(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.field_70180_af.func_187225_a(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.field_70180_af.func_187227_b(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public float getDistance() {
        return ((Float)this.field_70180_af.func_187225_a(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.field_70180_af.func_187227_b(DISTANCE, (Object)Float.valueOf(d));
    }

    public Vec3d getLookV() {
        CompoundNBT nbt = (CompoundNBT)this.field_70180_af.func_187225_a(LOOK_VEC);
        return new Vec3d(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public void setLookV(Vec3d v) {
        if (v != null) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74780_a("x", v.field_72450_a);
            nbt.func_74780_a("y", v.field_72448_b);
            nbt.func_74780_a("z", v.field_72449_c);
            this.field_70180_af.func_187227_b(LOOK_VEC, (Object)nbt);
        }
    }
}

