/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.Vec3d;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FaeAIFollow
extends Goal {
    private final CreatureEntity entity;
    private final Predicate<LivingEntity> followPredicate;
    private LivingEntity followingEntity;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float fard;
    private final float neard;
    private float oldWaterCost;
    private final float areaSize;
    private int timeFollowing;

    public FaeAIFollow(final CreatureEntity e, double speed, float far, float area, float near) {
        this.entity = e;
        this.followPredicate = new Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity r) {
                return r != null && e != r;
            }
        };
        this.speedModifier = speed;
        this.navigation = e.func_70661_as();
        this.fard = far;
        this.neard = near;
        this.areaSize = area;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        List list;
        if ((this.followingEntity == null || Math.random() > 0.05) && !(list = this.entity.field_70170_p.func_175647_a(LivingEntity.class, this.entity.func_174813_aQ().func_186662_g((double)this.areaSize), this.followPredicate)).isEmpty()) {
            for (LivingEntity creature : list) {
                if (creature.func_82150_aj()) continue;
                if (!(creature instanceof PlayerEntity) || EffectUtil.hasBuff(creature, ModEffects.FAY_SIGHT_EYES)) {
                    this.followingEntity = creature;
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.followingEntity != null && !this.navigation.func_75500_f() && this.entity.func_70068_e((Entity)this.followingEntity) < (double)(this.fard * this.fard);
    }

    public void func_75249_e() {
        this.timeFollowing = 0;
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.timeFollowing = 0;
        this.followingEntity = null;
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.followingEntity != null && !this.entity.func_110167_bD()) {
            ++this.timeFollowing;
            Vec3d motion = this.entity.func_213322_ci();
            double motionX = motion.field_72450_a;
            double motionY = motion.field_72448_b;
            double motionZ = motion.field_72449_c;
            this.entity.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.entity.func_70646_bf());
            float f = 0.01f;
            if (!Utils.isBlockAir(this.entity.field_70170_p, this.entity.func_180425_c().func_177977_b()) || Math.random() > 0.6) {
                // empty if block
            }
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.timeToRecalcPath = 1;
                double d0 = this.entity.func_226277_ct_() - this.followingEntity.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = 0.0) * d1 + (d2 = this.entity.func_226281_cx_() - this.followingEntity.func_226281_cx_()) * d2;
                if (d3 < (double)(this.fard * this.fard)) {
                    Vec3d toFollowing = new Vec3d(-d0, -d1, -d2).func_72432_b().func_186678_a(10.0);
                    float reachfactor = 0.01f;
                    if (d3 < (double)(this.neard * this.neard)) {
                        toFollowing = toFollowing.func_178785_b(90.0f);
                        motionX = toFollowing.field_72450_a * 0.03;
                        motionZ = toFollowing.field_72449_c * 0.03;
                        toFollowing = toFollowing.func_178785_b(-90.0f);
                        motionX += (motionX - toFollowing.field_72450_a) * (double)reachfactor;
                        motionZ += (motionZ - toFollowing.field_72449_c) * (double)reachfactor;
                    } else {
                        motionX -= (motionX - toFollowing.field_72450_a) * (double)reachfactor;
                        motionZ -= (motionZ - toFollowing.field_72449_c) * (double)reachfactor;
                    }
                } else {
                    this.navigation.func_75499_g();
                }
            }
            this.entity.func_213293_j(motionX, motionY, motionZ);
        }
        if (this.timeFollowing > 200) {
            this.followingEntity = null;
        }
    }
}

