/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.source;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.func.CellFunc;
import me.dags.noise.func.DistanceFunc;
import me.dags.noise.func.EdgeFunc;
import me.dags.noise.func.Interpolation;
import me.dags.noise.source.Constant;
import me.dags.noise.source.FastBillow;
import me.dags.noise.source.FastCell;
import me.dags.noise.source.FastCellEdge;
import me.dags.noise.source.FastCubic;
import me.dags.noise.source.FastPerlin;
import me.dags.noise.source.FastRidge;
import me.dags.noise.source.FastSimplex;
import me.dags.noise.source.FastSin;
import me.dags.noise.source.FastSource;
import me.dags.noise.source.Rand;

public class Builder {
    public static final int DEFAULT_SEED = 1337;
    public static final int DEFAULT_OCTAVES = 3;
    public static final float DEFAULT_GAIN = 0.5f;
    public static final float DEFAULT_RIDGE_GAIN = 0.975f;
    public static final float DEFAULT_LACUNARITY = 2.0f;
    public static final float DEFAULT_FREQUENCY = 0.01f;
    public static final CellFunc DEFAULT_CELL_FUNC = CellFunc.CELL_VALUE;
    public static final EdgeFunc DEFAULT_EDGE_FUNC = EdgeFunc.DISTANCE_2;
    public static final DistanceFunc DEFAULT_DIST_FUNC = DistanceFunc.EUCLIDEAN;
    public static Interpolation DEFAULT_INTERPOLATION = Interpolation.CURVE3;
    private int seed = 1337;
    private int octaves = 3;
    private float gain = Float.MAX_VALUE;
    private float lacunarity = 2.0f;
    private float frequency = 0.01f;
    private Module source = Source.ZERO;
    private CellFunc cellFunc = DEFAULT_CELL_FUNC;
    private EdgeFunc edgeFunc = DEFAULT_EDGE_FUNC;
    private DistanceFunc distFunc = DEFAULT_DIST_FUNC;
    private Interpolation interpolation = DEFAULT_INTERPOLATION;

    public int getSeed() {
        return this.seed;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public float getGain() {
        if (this.gain == Float.MAX_VALUE) {
            this.gain = 0.5f;
        }
        return this.gain;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getLacunarity() {
        return this.lacunarity;
    }

    public Interpolation getInterp() {
        return this.interpolation;
    }

    public CellFunc getCellFunc() {
        return this.cellFunc;
    }

    public EdgeFunc getEdgeFunc() {
        return this.edgeFunc;
    }

    public DistanceFunc getDistFunc() {
        return this.distFunc;
    }

    public Module getSource() {
        return this.source;
    }

    public Builder seed(int seed) {
        this.seed = seed;
        return this;
    }

    public Builder octaves(int octaves) {
        this.octaves = octaves;
        return this;
    }

    public Builder gain(double gain) {
        this.gain = (float)gain;
        return this;
    }

    public Builder lacunarity(double lacunarity) {
        this.lacunarity = (float)lacunarity;
        return this;
    }

    public Builder scale(int frequency) {
        this.frequency = 1.0f / (float)frequency;
        return this;
    }

    public Builder frequency(double frequency) {
        this.frequency = (float)frequency;
        return this;
    }

    public Builder interp(Interpolation interpolation) {
        this.interpolation = interpolation;
        return this;
    }

    public Builder cellFunc(CellFunc cellFunc) {
        this.cellFunc = cellFunc;
        return this;
    }

    public Builder edgeFunc(EdgeFunc cellType) {
        this.edgeFunc = cellType;
        return this;
    }

    public Builder distFunc(DistanceFunc cellDistance) {
        this.distFunc = cellDistance;
        return this;
    }

    public Builder source(Module source) {
        this.source = source;
        return this;
    }

    public FastSource perlin() {
        return new FastPerlin(this);
    }

    public FastSource simplex() {
        return new FastSimplex(this);
    }

    public FastSource ridge() {
        if (this.gain == Float.MAX_VALUE) {
            this.gain = 0.975f;
        }
        return new FastRidge(this);
    }

    public FastSource billow() {
        return new FastBillow(this);
    }

    public FastSource cubic() {
        return new FastCubic(this);
    }

    public FastSource cell() {
        return new FastCell(this);
    }

    public FastSource cellEdge() {
        return new FastCellEdge(this);
    }

    public FastSource sin() {
        return new FastSin(this);
    }

    public Module constant() {
        return new Constant(this);
    }

    public Rand rand() {
        return new Rand(this);
    }

    public Module build(Source source) {
        return source.build(this);
    }

    public Module build(Class<? extends Module> type) {
        try {
            Constructor<? extends Module> constructor = type.getConstructor(Builder.class);
            return constructor.newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return this.perlin();
        }
    }
}

