/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material;

import com.google.common.collect.Sets;
import com.terraforged.core.util.concurrent.ObjectPool;
import com.terraforged.mod.util.DummyBlockReader;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MaterialHelper {
    private static final Set<Block> BLACKLIST = Sets.newHashSet((Object[])new Block[]{Blocks.field_196694_dh, Blocks.field_196687_dd, Blocks.field_196692_dg, Blocks.field_196690_df, Blocks.field_196686_dc, Blocks.field_196688_de, Blocks.field_180399_cE, Blocks.field_196611_F, Blocks.field_150425_aM, Blocks.field_226907_mc_, Blocks.field_226908_md_, Blocks.field_226905_ma_, Blocks.field_226906_mb_, Blocks.field_222436_lZ});

    public static boolean isAir(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_201941_jj || block == Blocks.field_201940_ji;
    }

    public static boolean isGrass(Block block) {
        return block == Blocks.field_196658_i || block == Blocks.field_150391_bh;
    }

    public static boolean isStone(Block block) {
        return Tags.Blocks.STONE.func_199685_a_((Object)block) && !MaterialHelper.isBlacklisted(block) && !("" + block.getRegistryName()).contains("polished_");
    }

    public static boolean isDirt(Block block) {
        return Tags.Blocks.DIRT.func_199685_a_((Object)block) && !MaterialHelper.isBlacklisted(block);
    }

    public static boolean isClay(Block block) {
        return block.func_176223_P().func_185904_a() == Material.field_151571_B && !MaterialHelper.isBlacklisted(block);
    }

    public static boolean isSand(Block block) {
        return BlockTags.field_203436_u.func_199685_a_((Object)block) && !MaterialHelper.isBlacklisted(block) && !(block instanceof ConcretePowderBlock);
    }

    public static boolean isSediment(Block block) {
        return (MaterialHelper.isSand(block) || MaterialHelper.isGravel(block)) && !MaterialHelper.isBlacklisted(block) && !(block instanceof ConcretePowderBlock);
    }

    public static boolean isGravel(Block block) {
        return MaterialHelper.getName(block).contains("gravel");
    }

    public static boolean isOre(Block block) {
        return Tags.Blocks.ORES.func_199685_a_((Object)block) && !MaterialHelper.isBlacklisted(block);
    }

    public static boolean isBlacklisted(Block block) {
        return BLACKLIST.contains(block);
    }

    public static String getName(IForgeRegistryEntry<?> entry) {
        return "" + entry.getRegistryName();
    }

    public static String getNamespace(IForgeRegistryEntry<?> entry) {
        ResourceLocation name = entry.getRegistryName();
        if (name == null) {
            return "unknown";
        }
        return name.func_110624_b();
    }

    public static float getHardness(BlockState state) {
        try (ObjectPool.Item<DummyBlockReader> reader = DummyBlockReader.pooled();){
            reader.getValue().set(state);
            float f = state.func_185887_b((IBlockReader)reader.getValue(), BlockPos.field_177992_a);
            return f;
        }
    }

    public static boolean isCube(BlockState state) {
        try (ObjectPool.Item<DummyBlockReader> reader = DummyBlockReader.pooled();){
            reader.getValue().set(state);
            boolean bl = state.func_215686_e((IBlockReader)reader.getValue(), BlockPos.field_177992_a);
            return bl;
        }
    }

    public static OreFeatureConfig getOreConfig(ConfiguredFeature<?, ?> feature) {
        if (feature.field_222738_b instanceof DecoratedFeatureConfig) {
            DecoratedFeatureConfig config = (DecoratedFeatureConfig)feature.field_222738_b;
            if (config.field_214689_a.field_222738_b instanceof OreFeatureConfig) {
                return (OreFeatureConfig)config.field_214689_a.field_222738_b;
            }
        }
        return null;
    }
}

