/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.page;

import com.terraforged.mod.gui.OverlayRenderer;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.ScrollPane;
import com.terraforged.mod.gui.element.TerraLabel;
import com.terraforged.mod.gui.element.TerraSlider;
import com.terraforged.mod.gui.element.TerraTextInput;
import com.terraforged.mod.gui.element.TerraToggle;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class Page
implements IGuiEventListener,
OverlayRenderer {
    protected static final Runnable NO_CALLBACK = () -> {};
    private static final int SLIDER_HEIGHT = 20;
    private static final int SLIDER_PAD = 2;
    private final Column[] columns;
    private final float[] sizes;
    private final int hpad;
    private final int vpad;
    protected OverlayScreen parent;

    public Page(int hpad, int vpad, float ... columnSizes) {
        this.hpad = hpad;
        this.vpad = vpad;
        this.sizes = columnSizes;
        this.columns = new Column[columnSizes.length];
    }

    public abstract void callback(Runnable var1);

    public abstract void save();

    public abstract void init(OverlayScreen var1);

    @Override
    public void renderOverlays(Screen screen, int mouseX, int mouseY) {
        for (Column column : this.columns) {
            if (column.scrollPane.children().isEmpty()) continue;
            column.scrollPane.renderOverlays(screen, mouseX, mouseY);
        }
    }

    public void visit(Consumer<ScrollPane> consumer) {
        for (Column column : this.columns) {
            if (column.scrollPane.children().isEmpty()) continue;
            consumer.accept(column.scrollPane);
        }
    }

    public boolean action(Function<ScrollPane, Boolean> action) {
        boolean result = false;
        for (Column column : this.columns) {
            if (column.scrollPane.children().isEmpty()) continue;
            boolean b = action.apply(column.scrollPane);
            result = b || result;
        }
        return result;
    }

    public void close() {
    }

    public String getTitle() {
        return "";
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public final void initPage(int marginH, int marginV, OverlayScreen parent) {
        this.parent = parent;
        int top = marginV;
        int left = marginH;
        int pageWidth = parent.width - marginH * 2;
        int pageHeight = parent.height;
        for (int i = 0; i < this.columns.length; ++i) {
            Column column;
            int columnWidth = Math.round(this.sizes[i] * (float)pageWidth) - 2 * this.hpad;
            this.columns[i] = column = new Column(left, top, columnWidth, pageHeight, this.hpad, this.vpad);
            left += columnWidth + 2 * this.hpad;
        }
        this.init(parent);
    }

    public void addElements(int x, int y, Column column, CompoundNBT settings, Consumer<Widget> consumer, Runnable callback) {
        this.addElements(x, y, column, settings, false, consumer, callback);
    }

    public void addElements(int x, int y, Column column, CompoundNBT settings, boolean deep, Consumer<Widget> consumer, Runnable callback) {
        AtomicInteger top = new AtomicInteger(y);
        NBTHelper.stream(settings).forEach(value -> {
            String name = value.func_74779_i("#display");
            Widget button = this.createButton(name, (CompoundNBT)value, callback);
            if (button != null) {
                button.setWidth(column.width);
                button.setHeight(20);
                button.x = x;
                button.y = top.getAndAdd(22);
                consumer.accept(button);
                this.onAddWidget(button);
            } else if (deep) {
                INBT child = value.func_74781_a("value");
                if (child == null || child.func_74732_a() != 10) {
                    return;
                }
                TerraLabel label = new TerraLabel(name);
                label.x = x;
                label.y = top.getAndAdd(22);
                consumer.accept((Widget)label);
                this.addElements(x, label.y, column, (CompoundNBT)child, consumer, callback);
            }
        });
    }

    public Widget createButton(String name, CompoundNBT value, Runnable callback) {
        INBT tag = value.func_74781_a("value");
        if (tag == null) {
            return null;
        }
        byte type = tag.func_74732_a();
        if (type == 3) {
            return new TerraSlider.Int(name + ": ", value).callback(callback);
        }
        if (type == 5) {
            return new TerraSlider.Float(name + ": ", value).callback(callback);
        }
        if (type == 8 && value.func_74764_b("#options")) {
            return new TerraToggle(name + ": ", value).callback(callback);
        }
        if (type == 8) {
            return new TerraTextInput(name, value);
        }
        return null;
    }

    public void onAddWidget(Widget widget) {
    }

    public static class Column {
        public final int left;
        public final int right;
        public final int top;
        public final int bottom;
        public final int width;
        public final int height;
        public final ScrollPane scrollPane;

        private Column(int left, int top, int width, int height, int vpad, int hpad) {
            this.left = left + vpad;
            this.right = left + width - vpad;
            this.top = top + hpad;
            this.bottom = height - hpad;
            this.width = width;
            this.height = height;
            this.scrollPane = new ScrollPane(25);
            this.scrollPane.updateSize(width, height, 30, height - 30);
            this.scrollPane.setLeftPos(this.left);
        }
    }
}

