/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod;

import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.chunk.ChunkGeneratorFactory;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.TerraGenSettings;
import com.terraforged.mod.chunk.test.TestChunkGenerator;
import com.terraforged.mod.gui.SettingsScreen;
import com.terraforged.mod.settings.DimesionSettings;
import com.terraforged.mod.settings.SettingsHelper;
import com.terraforged.mod.settings.TerraSettings;
import com.terraforged.mod.util.Environment;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TerraWorld
extends WorldType {
    public static final int VERSION = 1;
    private static final Set<WorldType> types = new HashSet<WorldType>();
    private final ChunkGeneratorFactory<?> factory;

    public TerraWorld(String name, ChunkGeneratorFactory<?> factory) {
        super(name);
        this.factory = factory;
        this.func_205392_a(true);
        types.add(this);
    }

    public ChunkGenerator<?> createChunkGenerator(World world) {
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            WorldInfo info = world.func_72912_H();
            int version = SettingsHelper.getVersion(info);
            TerraSettings settings = SettingsHelper.getSettings(info);
            SettingsHelper.syncSettings(world.func_72912_H(), settings, version);
            settings.dimensions.dimensionGenerators.apply(world.func_72912_H());
            Terrains terrains = Terrains.create(settings);
            TerraGenSettings genSettings = new TerraGenSettings(settings.structures);
            OverworldBiomeProviderSettings biomeSettings = new OverworldBiomeProviderSettings(world.func_72912_H());
            biomeSettings.func_205441_a((OverworldGenSettings)genSettings);
            world.func_72912_H().func_212242_b(NBTHelper.serializeCompact(settings));
            TerraContext context = new TerraContext((IWorld)world, terrains, settings);
            BiomeProvider biomeProvider = new BiomeProvider(context);
            Log.debug("Creating Terra {} generator", world.func_201675_m().func_186058_p().getRegistryName());
            return this.factory.create(context, biomeProvider, genSettings);
        }
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
            WorldType type = DimesionSettings.getWorldType(world.func_72912_H(), DimensionType.field_223228_b_);
            Log.debug("Creating {} {} generator", type.func_211888_a(), world.func_201675_m().func_186058_p().getRegistryName());
            return type.createChunkGenerator(world);
        }
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223229_c_) {
            WorldType type = DimesionSettings.getWorldType(world.func_72912_H(), DimensionType.field_223229_c_);
            Log.debug("Creating {} {} generator", type.func_211888_a(), world.func_201675_m().func_186058_p().getRegistryName());
            return type.createChunkGenerator(world);
        }
        return super.createChunkGenerator(world);
    }

    public double getHorizon(World world) {
        return 0.0;
    }

    public float getCloudHeight() {
        return 260.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onCustomizeButton(Minecraft mc, CreateWorldScreen gui) {
        mc.func_147108_a((Screen)new SettingsScreen(gui));
    }

    public static void init() {
        Log.info("Registered world type", new Object[0]);
        new TerraWorld("terraforged", TerraChunkGenerator::new);
        if (Environment.isDev()) {
            Log.info("Registered developer world type", new Object[0]);
            new TerraWorld("terratest", TestChunkGenerator::new);
        }
    }

    public static boolean isTerraType(WorldType type) {
        return types.contains(type);
    }

    public static boolean isTerraWorld(IWorld world) {
        if (world instanceof World) {
            return TerraWorld.isTerraType(((World)world).func_175624_G());
        }
        return false;
    }
}

