/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.feature.transformer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class FeatureTransformer
implements Function<JsonElement, JsonElement> {
    public static final FeatureTransformer NONE = FeatureTransformer.builder().build();
    private final boolean hasTransformations;
    private final Map<String, JsonElement> keyTransformers;
    private final Map<JsonPrimitive, JsonPrimitive> valueTransformers;

    private FeatureTransformer(Builder builder) {
        this.keyTransformers = builder.keyTransformers;
        this.valueTransformers = builder.valueTransformers;
        this.hasTransformations = !this.keyTransformers.isEmpty() || !this.valueTransformers.isEmpty();
        builder.keyTransformers = Collections.emptyMap();
        builder.valueTransformers = Collections.emptyMap();
    }

    @Override
    public JsonElement apply(JsonElement element) {
        if (this.hasTransformations) {
            if (element.isJsonArray()) {
                return this.transformArray(element.getAsJsonArray());
            }
            if (element.isJsonObject()) {
                return this.transformObject(element.getAsJsonObject());
            }
            if (element.isJsonPrimitive()) {
                return this.transformValue(element.getAsJsonPrimitive());
            }
        }
        return element;
    }

    private JsonPrimitive transformValue(JsonPrimitive primitive) {
        return this.valueTransformers.getOrDefault(primitive, primitive);
    }

    private JsonArray transformArray(JsonArray source) {
        JsonArray dest = new JsonArray();
        for (JsonElement element : source) {
            dest.add(this.apply(element));
        }
        return dest;
    }

    private JsonObject transformObject(JsonObject source) {
        JsonObject dest = new JsonObject();
        for (Map.Entry entry : source.entrySet()) {
            JsonElement result = this.transformEntry((String)entry.getKey(), (JsonElement)entry.getValue());
            dest.add((String)entry.getKey(), result);
        }
        return dest;
    }

    private JsonElement transformEntry(String key, JsonElement value) {
        JsonElement keyResult = this.keyTransformers.get(key);
        if (keyResult != null) {
            return keyResult;
        }
        return this.apply(value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> FeatureTransformer replace(T find, T replace) {
        if (find instanceof String) {
            return FeatureTransformer.builder().value((String)find, (String)replace).build();
        }
        if (find instanceof Number) {
            return FeatureTransformer.builder().value((Number)find, (Number)replace).build();
        }
        if (find instanceof Boolean) {
            return FeatureTransformer.builder().value((Boolean)find, (Boolean)replace).build();
        }
        return NONE;
    }

    public static class Builder {
        private Map<String, JsonElement> keyTransformers = Collections.emptyMap();
        private Map<JsonPrimitive, JsonPrimitive> valueTransformers = Collections.emptyMap();

        public Builder key(String key, boolean value) {
            return this.key(key, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
        }

        public Builder key(String key, Number value) {
            return this.key(key, (JsonElement)new JsonPrimitive(value));
        }

        public Builder key(String key, String value) {
            return this.key(key, (JsonElement)new JsonPrimitive(value));
        }

        public Builder key(String key, JsonElement value) {
            if (this.keyTransformers.isEmpty()) {
                this.keyTransformers = new HashMap<String, JsonElement>();
            }
            this.keyTransformers.put(key, value);
            return this;
        }

        public Builder value(boolean find, boolean replace) {
            return this.value(new JsonPrimitive(Boolean.valueOf(find)), new JsonPrimitive(Boolean.valueOf(replace)));
        }

        public Builder value(Number find, Number replace) {
            return this.value(new JsonPrimitive(find), new JsonPrimitive(replace));
        }

        public Builder value(String find, String replace) {
            return this.value(new JsonPrimitive(find), new JsonPrimitive(replace));
        }

        public Builder value(JsonPrimitive find, JsonPrimitive replace) {
            if (this.valueTransformers.isEmpty()) {
                this.valueTransformers = new HashMap<JsonPrimitive, JsonPrimitive>();
            }
            this.valueTransformers.put(find, replace);
            return this;
        }

        public FeatureTransformer build() {
            return new FeatureTransformer(this);
        }
    }
}

