/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.concurrent.cache;

import com.terraforged.core.util.concurrent.ThreadPool;
import com.terraforged.core.util.concurrent.cache.ExpiringEntry;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;

public class CacheEntry<T>
implements ExpiringEntry {
    private volatile long timestamp;
    private final Future<T> task;

    public CacheEntry(Future<T> task) {
        this.task = task;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDone() {
        return this.task.isDone();
    }

    public T get() {
        if (this.task instanceof ForkJoinTask) {
            return (T)((ForkJoinTask)this.task).join();
        }
        try {
            return this.task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> CacheEntry<T> supply(Future<T> future) {
        return new CacheEntry<T>(future);
    }

    public static <T> CacheEntry<T> supplyAsync(Callable<T> callable, ThreadPool executor) {
        return new CacheEntry<T>(executor.submit(callable));
    }
}

