/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraftforge.common.IPlantable;

public class BaseTreeFeatureConfig
implements IFeatureConfig {
    public final BlockStateProvider field_227368_m_;
    public final BlockStateProvider field_227369_n_;
    public final List<TreeDecorator> field_227370_o_;
    public final int field_227371_p_;
    public transient boolean field_227372_q_;
    protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;

    protected BaseTreeFeatureConfig(BlockStateProvider trunkProviderIn, BlockStateProvider leavesProviderIn, List<TreeDecorator> decoratorsIn, int baseHeightIn) {
        this.field_227368_m_ = trunkProviderIn;
        this.field_227369_n_ = leavesProviderIn;
        this.field_227370_o_ = decoratorsIn;
        this.field_227371_p_ = baseHeightIn;
    }

    public void func_227373_a_() {
        this.field_227372_q_ = true;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("trunk_provider"), this.field_227368_m_.func_218175_a(ops)).put(ops.createString("leaves_provider"), this.field_227369_n_.func_218175_a(ops)).put(ops.createString("decorators"), ops.createList(this.field_227370_o_.stream().map(p_227375_1_ -> p_227375_1_.func_218175_a(ops)))).put(ops.createString("base_height"), ops.createInt(this.field_227371_p_));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    protected BaseTreeFeatureConfig setSapling(IPlantable value) {
        this.sapling = value;
        return this;
    }

    public IPlantable getSapling() {
        return this.sapling;
    }

    public static <T> BaseTreeFeatureConfig func_227376_b_(Dynamic<T> data) {
        BlockStateProviderType<?> blockstateprovidertype = Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)data.get("trunk_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType<?> blockstateprovidertype1 = Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)data.get("leaves_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        return new BaseTreeFeatureConfig((BlockStateProvider)blockstateprovidertype.func_227399_a_(data.get("trunk_provider").orElseEmptyMap()), (BlockStateProvider)blockstateprovidertype1.func_227399_a_(data.get("leaves_provider").orElseEmptyMap()), data.get("decorators").asList(p_227374_0_ -> Registry.field_229390_w_.func_82594_a(new ResourceLocation((String)p_227374_0_.get("type").asString().orElseThrow(RuntimeException::new))).func_227431_a_((Dynamic<?>)p_227374_0_)), data.get("base_height").asInt(0));
    }

    public static <T> BaseTreeFeatureConfig deserializeJungle(Dynamic<T> data) {
        return BaseTreeFeatureConfig.func_227376_b_(data).setSapling((IPlantable)Blocks.field_196678_w);
    }

    public static class Builder {
        public final BlockStateProvider field_227377_a_;
        public final BlockStateProvider field_227378_b_;
        private List<TreeDecorator> field_227379_c_ = Lists.newArrayList();
        private int field_227380_d_ = 0;
        protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;

        public Builder(BlockStateProvider trunkProviderIn, BlockStateProvider leavesProviderIn) {
            this.field_227377_a_ = trunkProviderIn;
            this.field_227378_b_ = leavesProviderIn;
        }

        public Builder func_225569_d_(int baseHeightIn) {
            this.field_227380_d_ = baseHeightIn;
            return this;
        }

        public Builder setSapling(IPlantable value) {
            this.sapling = value;
            return this;
        }

        public BaseTreeFeatureConfig func_225568_b_() {
            return new BaseTreeFeatureConfig(this.field_227377_a_, this.field_227378_b_, this.field_227379_c_, this.field_227380_d_).setSapling(this.sapling);
        }
    }
}

