/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.STeamsPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.DemoPlayerInteractionManager;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.OpList;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorld;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File field_152613_a = new File("banned-players.json");
    public static final File field_152614_b = new File("banned-ips.json");
    public static final File field_152615_c = new File("ops.json");
    public static final File field_152616_d = new File("whitelist.json");
    private static final Logger field_148546_d = LogManager.getLogger();
    private static final SimpleDateFormat field_72403_e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer field_72400_f;
    private final List<ServerPlayerEntity> field_72404_b = Lists.newArrayList();
    private final Map<UUID, ServerPlayerEntity> field_177454_f = Maps.newHashMap();
    private final BanList field_72401_g = new BanList(field_152613_a);
    private final IPBanList field_72413_h = new IPBanList(field_152614_b);
    private final OpList field_72414_i = new OpList(field_152615_c);
    private final WhiteList field_72411_j = new WhiteList(field_152616_d);
    private final Map<UUID, ServerStatisticsManager> field_148547_k = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> field_192055_p = Maps.newHashMap();
    private IPlayerFileData field_72412_k;
    private boolean field_72409_l;
    protected final int field_72405_c;
    private int field_72402_d;
    private GameType field_72410_m;
    private boolean field_72407_n;
    private int field_72408_o;
    private final List<ServerPlayerEntity> playersView = Collections.unmodifiableList(this.field_72404_b);

    public PlayerList(MinecraftServer p_i50688_1_, int p_i50688_2_) {
        this.field_72400_f = p_i50688_1_;
        this.field_72405_c = p_i50688_2_;
        this.func_152608_h().func_152686_a(true);
        this.func_72363_f().func_152686_a(true);
    }

    public void func_72355_a(NetworkManager netManager, ServerPlayerEntity playerIn) {
        ServerWorld serverworld;
        GameProfile gameprofile = playerIn.func_146103_bH();
        PlayerProfileCache playerprofilecache = this.field_72400_f.func_152358_ax();
        GameProfile gameprofile1 = playerprofilecache.func_152652_a(gameprofile.getId());
        String s = gameprofile1 == null ? gameprofile.getName() : gameprofile1.getName();
        playerprofilecache.func_152649_a(gameprofile);
        CompoundNBT compoundnbt = this.func_72380_a(playerIn);
        ServerWorld serverWorld = serverworld = playerIn.field_71093_bK != null ? this.field_72400_f.func_71218_a(playerIn.field_71093_bK) : null;
        if (serverworld == null) {
            playerIn.field_71093_bK = DimensionType.field_223227_a_;
            serverworld = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
            playerIn.func_70107_b(serverworld.func_72912_H().func_76079_c(), serverworld.func_72912_H().func_76075_d(), serverworld.func_72912_H().func_76074_e());
        }
        playerIn.func_70029_a(serverworld);
        playerIn.field_71134_c.func_73080_a((ServerWorld)playerIn.field_70170_p);
        String s1 = "local";
        if (netManager.func_74430_c() != null) {
            s1 = netManager.func_74430_c().toString();
        }
        field_148546_d.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)playerIn.func_200200_C_().getString(), (Object)s1, (Object)playerIn.func_145782_y(), (Object)playerIn.func_226277_ct_(), (Object)playerIn.func_226278_cu_(), (Object)playerIn.func_226281_cx_());
        WorldInfo worldinfo = serverworld.func_72912_H();
        this.func_72381_a(playerIn, null, serverworld);
        ServerPlayNetHandler serverplaynethandler = new ServerPlayNetHandler(this.field_72400_f, netManager, playerIn);
        NetworkHooks.sendMCRegistryPackets((NetworkManager)netManager, (String)"PLAY_TO_CLIENT");
        NetworkHooks.sendDimensionDataPacket((NetworkManager)netManager, (ServerPlayerEntity)playerIn);
        GameRules gamerules = serverworld.func_82736_K();
        boolean flag = gamerules.func_223586_b(GameRules.field_226683_z_);
        boolean flag1 = gamerules.func_223586_b(GameRules.field_223612_o);
        serverplaynethandler.func_147359_a(new SJoinGamePacket(playerIn.func_145782_y(), playerIn.field_71134_c.func_73081_b(), WorldInfo.func_227498_c_(worldinfo.func_76063_b()), worldinfo.func_76093_s(), serverworld.field_73011_w.func_186058_p(), this.func_72352_l(), worldinfo.func_76067_t(), this.field_72402_d, flag1, !flag));
        serverplaynethandler.func_147359_a(new SCustomPayloadPlayPacket(SCustomPayloadPlayPacket.field_209911_b, new PacketBuffer(Unpooled.buffer()).func_180714_a(this.func_72365_p().getServerModName())));
        serverplaynethandler.func_147359_a((IPacket<?>)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        serverplaynethandler.func_147359_a((IPacket<?>)new SPlayerAbilitiesPacket(playerIn.field_71075_bZ));
        serverplaynethandler.func_147359_a((IPacket<?>)new SHeldItemChangePacket(playerIn.field_71071_by.field_70461_c));
        serverplaynethandler.func_147359_a((IPacket<?>)new SUpdateRecipesPacket(this.field_72400_f.func_199529_aN().func_199510_b()));
        serverplaynethandler.func_147359_a((IPacket<?>)new STagsListPacket(this.field_72400_f.func_199731_aO()));
        this.func_187243_f(playerIn);
        playerIn.func_147099_x().func_150877_d();
        playerIn.func_192037_E().func_192826_c(playerIn);
        this.func_96456_a(serverworld.func_96441_U(), playerIn);
        this.field_72400_f.func_147132_au();
        TranslationTextComponent itextcomponent = playerIn.func_146103_bH().getName().equalsIgnoreCase(s) ? new TranslationTextComponent("multiplayer.player.joined", playerIn.func_145748_c_()) : new TranslationTextComponent("multiplayer.player.joined.renamed", playerIn.func_145748_c_(), s);
        this.func_148539_a(itextcomponent.func_211708_a(TextFormatting.YELLOW));
        serverplaynethandler.func_147364_a(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), playerIn.field_70177_z, playerIn.field_70125_A);
        this.addPlayer(playerIn);
        this.field_177454_f.put(playerIn.func_110124_au(), playerIn);
        this.func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{playerIn}));
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            playerIn.field_71135_a.func_147359_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.ADD_PLAYER, new ServerPlayerEntity[]{this.field_72404_b.get(i)}));
        }
        serverworld.func_217435_c(playerIn);
        this.field_72400_f.func_201300_aS().func_201383_a(playerIn);
        this.func_72354_b(playerIn, serverworld);
        if (!this.field_72400_f.func_147133_T().isEmpty()) {
            playerIn.func_175397_a(this.field_72400_f.func_147133_T(), this.field_72400_f.func_175581_ab());
        }
        for (EffectInstance effectinstance : playerIn.func_70651_bq()) {
            serverplaynethandler.func_147359_a((IPacket<?>)new SPlayEntityEffectPacket(playerIn.func_145782_y(), effectinstance));
        }
        if (compoundnbt != null && compoundnbt.func_150297_b("RootVehicle", 10)) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("RootVehicle");
            ServerWorld worldf = serverworld;
            Entity entity1 = EntityType.func_220335_a(compoundnbt1.func_74775_l("Entity"), serverworld, p_217885_1_ -> !worldf.func_217470_d((Entity)((Object)p_217885_1_)) ? null : p_217885_1_);
            if (entity1 != null) {
                UUID uuid = compoundnbt1.func_186857_a("Attach");
                if (entity1.func_110124_au().equals(uuid)) {
                    playerIn.func_184205_a(entity1, true);
                } else {
                    for (Entity entity : entity1.func_184182_bu()) {
                        if (!entity.func_110124_au().equals(uuid)) continue;
                        playerIn.func_184205_a(entity, true);
                        break;
                    }
                }
                if (!playerIn.func_184218_aH()) {
                    field_148546_d.warn("Couldn't reattach entity to player");
                    serverworld.func_217467_h(entity1);
                    for (Entity entity2 : entity1.func_184182_bu()) {
                        serverworld.func_217467_h(entity2);
                    }
                }
            }
        }
        playerIn.func_71116_b();
        BasicEventHooks.firePlayerLoggedIn((PlayerEntity)playerIn);
    }

    protected void func_96456_a(ServerScoreboard scoreboardIn, ServerPlayerEntity playerIn) {
        HashSet set = Sets.newHashSet();
        for (ScorePlayerTeam scoreplayerteam : scoreboardIn.func_96525_g()) {
            playerIn.field_71135_a.func_147359_a((IPacket<?>)new STeamsPacket(scoreplayerteam, 0));
        }
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreobjective = scoreboardIn.func_96539_a(i);
            if (scoreobjective == null || set.contains(scoreobjective)) continue;
            for (IPacket ipacket : scoreboardIn.func_96550_d(scoreobjective)) {
                playerIn.field_71135_a.func_147359_a(ipacket);
            }
            set.add(scoreobjective);
        }
    }

    public void func_212504_a(ServerWorld p_212504_1_) {
        this.field_72412_k = p_212504_1_.func_217485_w();
        p_212504_1_.func_175723_af().func_177737_a(new IBorderListener(){

            public void func_177694_a(WorldBorder border, double newSize) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_SIZE));
            }

            public void func_177692_a(WorldBorder border, double oldSize, double newSize, long time) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.LERP_SIZE));
            }

            public void func_177693_a(WorldBorder border, double x, double z) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_CENTER));
            }

            public void func_177691_a(WorldBorder border, int newTime) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_WARNING_TIME));
            }

            public void func_177690_b(WorldBorder border, int newDistance) {
                PlayerList.this.func_148540_a((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_WARNING_BLOCKS));
            }

            public void func_177696_b(WorldBorder border, double newAmount) {
            }

            public void func_177695_c(WorldBorder border, double newSize) {
            }
        });
    }

    @Nullable
    public CompoundNBT func_72380_a(ServerPlayerEntity playerIn) {
        CompoundNBT compoundnbt1;
        CompoundNBT compoundnbt = this.field_72400_f.func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_76072_h();
        if (playerIn.func_200200_C_().getString().equals(this.field_72400_f.func_71214_G()) && compoundnbt != null) {
            compoundnbt1 = compoundnbt;
            playerIn.func_70020_e(compoundnbt);
            field_148546_d.debug("loading single player");
            ForgeEventFactory.firePlayerLoadingEvent((PlayerEntity)playerIn, (IPlayerFileData)this.field_72412_k, (String)playerIn.func_110124_au().toString());
        } else {
            compoundnbt1 = this.field_72412_k.func_75752_b((PlayerEntity)playerIn);
        }
        return compoundnbt1;
    }

    protected void func_72391_b(ServerPlayerEntity playerIn) {
        PlayerAdvancements playeradvancements;
        if (playerIn.field_71135_a == null) {
            return;
        }
        this.field_72412_k.func_75753_a((PlayerEntity)playerIn);
        ServerStatisticsManager serverstatisticsmanager = this.field_148547_k.get(playerIn.func_110124_au());
        if (serverstatisticsmanager != null) {
            serverstatisticsmanager.func_150883_b();
        }
        if ((playeradvancements = this.field_192055_p.get(playerIn.func_110124_au())) != null) {
            playeradvancements.func_192749_b();
        }
    }

    public void func_72367_e(ServerPlayerEntity playerIn) {
        Entity entity;
        BasicEventHooks.firePlayerLoggedOut((PlayerEntity)playerIn);
        ServerWorld serverworld = playerIn.func_71121_q();
        playerIn.func_195066_a(Stats.field_75947_j);
        this.func_72391_b(playerIn);
        if (playerIn.func_184218_aH() && (entity = playerIn.func_184208_bv()).func_200601_bK()) {
            field_148546_d.debug("Removing player mount");
            playerIn.func_184210_p();
            serverworld.func_217467_h(entity);
            for (Entity entity1 : entity.func_184182_bu()) {
                serverworld.func_217467_h(entity1);
            }
            serverworld.func_212866_a_(playerIn.field_70176_ah, playerIn.field_70164_aj).func_76630_e();
        }
        playerIn.func_213319_R();
        serverworld.func_217434_e(playerIn);
        playerIn.func_192039_O().func_192745_a();
        this.removePlayer(playerIn);
        this.field_72400_f.func_201300_aS().func_201382_b(playerIn);
        UUID uuid = playerIn.func_110124_au();
        ServerPlayerEntity serverplayerentity = this.field_177454_f.get(uuid);
        if (serverplayerentity == playerIn) {
            this.field_177454_f.remove(uuid);
            this.field_148547_k.remove(uuid);
            this.field_192055_p.remove(uuid);
        }
        this.func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER, new ServerPlayerEntity[]{playerIn}));
    }

    @Nullable
    public ITextComponent func_206258_a(SocketAddress p_206258_1_, GameProfile p_206258_2_) {
        if (this.field_72401_g.func_152702_a(p_206258_2_)) {
            ProfileBanEntry profilebanentry = (ProfileBanEntry)this.field_72401_g.func_152683_b((Object)p_206258_2_);
            TranslationTextComponent itextcomponent1 = new TranslationTextComponent("multiplayer.disconnect.banned.reason", profilebanentry.func_73686_f());
            if (profilebanentry.func_73680_d() != null) {
                itextcomponent1.func_150257_a((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned.expiration", field_72403_e.format(profilebanentry.func_73680_d())));
            }
            return itextcomponent1;
        }
        if (!this.func_152607_e(p_206258_2_)) {
            return new TranslationTextComponent("multiplayer.disconnect.not_whitelisted", new Object[0]);
        }
        if (this.field_72413_h.func_152708_a(p_206258_1_)) {
            IPBanEntry ipbanentry = this.field_72413_h.func_152709_b(p_206258_1_);
            TranslationTextComponent itextcomponent = new TranslationTextComponent("multiplayer.disconnect.banned_ip.reason", ipbanentry.func_73686_f());
            if (ipbanentry.func_73680_d() != null) {
                itextcomponent.func_150257_a((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned_ip.expiration", field_72403_e.format(ipbanentry.func_73680_d())));
            }
            return itextcomponent;
        }
        return this.field_72404_b.size() >= this.field_72405_c && !this.func_183023_f(p_206258_2_) ? new TranslationTextComponent("multiplayer.disconnect.server_full", new Object[0]) : null;
    }

    public ServerPlayerEntity func_148545_a(GameProfile profile) {
        UUID uuid = PlayerEntity.func_146094_a(profile);
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            Object serverplayerentity = this.field_72404_b.get(i);
            if (!serverplayerentity.func_110124_au().equals(uuid)) continue;
            list.add(serverplayerentity);
        }
        ServerPlayerEntity serverplayerentity2 = this.field_177454_f.get(profile.getId());
        if (serverplayerentity2 != null && !list.contains((Object)serverplayerentity2)) {
            list.add(serverplayerentity2);
        }
        for (ServerPlayerEntity serverplayerentity1 : list) {
            serverplayerentity1.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.duplicate_login", new Object[0]));
        }
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(this.field_72400_f.func_71218_a(DimensionType.field_223227_a_)) : new PlayerInteractionManager(this.field_72400_f.func_71218_a(DimensionType.field_223227_a_));
        return new ServerPlayerEntity(this.field_72400_f, this.field_72400_f.func_71218_a(DimensionType.field_223227_a_), profile, (PlayerInteractionManager)playerinteractionmanager);
    }

    public ServerPlayerEntity func_72368_a(ServerPlayerEntity playerIn, DimensionType dimension, boolean conqueredEnd) {
        ServerWorld world = this.field_72400_f.func_71218_a(dimension);
        if (world == null) {
            dimension = playerIn.getSpawnDimension();
        } else if (!world.func_201675_m().func_76567_e()) {
            dimension = world.func_201675_m().getRespawnDimension(playerIn);
        }
        if (this.field_72400_f.func_71218_a(dimension) == null) {
            dimension = DimensionType.field_223227_a_;
        }
        this.removePlayer(playerIn);
        playerIn.func_71121_q().removePlayer(playerIn, true);
        BlockPos blockpos = playerIn.getBedLocation(dimension);
        boolean flag = playerIn.isSpawnForced(dimension);
        playerIn.field_71093_bK = dimension;
        Object playerinteractionmanager = this.field_72400_f.func_71242_L() ? new DemoPlayerInteractionManager(this.field_72400_f.func_71218_a(playerIn.field_71093_bK)) : new PlayerInteractionManager(this.field_72400_f.func_71218_a(playerIn.field_71093_bK));
        ServerPlayerEntity serverplayerentity = new ServerPlayerEntity(this.field_72400_f, this.field_72400_f.func_71218_a(playerIn.field_71093_bK), playerIn.func_146103_bH(), (PlayerInteractionManager)playerinteractionmanager);
        serverplayerentity.field_71135_a = playerIn.field_71135_a;
        serverplayerentity.func_193104_a(playerIn, conqueredEnd);
        playerIn.remove(false);
        serverplayerentity.field_71093_bK = dimension;
        serverplayerentity.func_145769_d(playerIn.func_145782_y());
        serverplayerentity.func_184819_a(playerIn.func_184591_cq());
        for (String s : playerIn.func_184216_O()) {
            serverplayerentity.func_184211_a(s);
        }
        ServerWorld serverworld = this.field_72400_f.func_71218_a(playerIn.field_71093_bK);
        this.func_72381_a(serverplayerentity, playerIn, serverworld);
        if (blockpos != null) {
            Optional<Vec3d> optional = PlayerEntity.func_213822_a(this.field_72400_f.func_71218_a(playerIn.field_71093_bK), blockpos, flag);
            if (optional.isPresent()) {
                Vec3d vec3d = optional.get();
                serverplayerentity.func_70012_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.0f, 0.0f);
                serverplayerentity.setSpawnPoint(blockpos, flag, false, dimension);
            } else {
                serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(0, 0.0f));
            }
        }
        while (!serverworld.func_226669_j_(serverplayerentity) && serverplayerentity.func_226278_cu_() < 256.0) {
            serverplayerentity.func_70107_b(serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_() + 1.0, serverplayerentity.func_226281_cx_());
        }
        WorldInfo worldinfo = serverplayerentity.field_70170_p.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)serverplayerentity.field_71135_a.field_147371_a, (ServerPlayerEntity)serverplayerentity);
        serverplayerentity.field_71135_a.func_147359_a(new SRespawnPacket(serverplayerentity.field_71093_bK, WorldInfo.func_227498_c_(worldinfo.func_76063_b()), worldinfo.func_76067_t(), serverplayerentity.field_71134_c.func_73081_b()));
        BlockPos blockpos1 = serverworld.func_175694_M();
        serverplayerentity.field_71135_a.func_147364_a(serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_(), serverplayerentity.func_226281_cx_(), serverplayerentity.field_70177_z, serverplayerentity.field_70125_A);
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SSpawnPositionPacket(blockpos1));
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SSetExperiencePacket(serverplayerentity.field_71106_cc, serverplayerentity.field_71067_cb, serverplayerentity.field_71068_ca));
        this.func_72354_b(serverplayerentity, serverworld);
        this.func_187243_f(serverplayerentity);
        serverworld.func_217433_d(serverplayerentity);
        this.addPlayer(serverplayerentity);
        this.field_177454_f.put(serverplayerentity.func_110124_au(), serverplayerentity);
        serverplayerentity.func_71116_b();
        serverplayerentity.func_70606_j(serverplayerentity.func_110143_aJ());
        BasicEventHooks.firePlayerRespawnEvent((PlayerEntity)serverplayerentity, (boolean)conqueredEnd);
        return serverplayerentity;
    }

    public void func_187243_f(ServerPlayerEntity player) {
        GameProfile gameprofile = player.func_146103_bH();
        int i = this.field_72400_f.func_211833_a(gameprofile);
        this.func_187245_a(player, i);
    }

    public void func_72374_b() {
        if (++this.field_72408_o > 600) {
            this.func_148540_a((IPacket<?>)new SPlayerListItemPacket(SPlayerListItemPacket.Action.UPDATE_LATENCY, this.field_72404_b));
            this.field_72408_o = 0;
        }
    }

    public void func_148540_a(IPacket<?> packetIn) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_148537_a(IPacket<?> packetIn, DimensionType dimension) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            ServerPlayerEntity serverplayerentity = this.field_72404_b.get(i);
            if (serverplayerentity.field_71093_bK != dimension) continue;
            serverplayerentity.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_177453_a(PlayerEntity player, ITextComponent message) {
        Team team = player.func_96124_cp();
        if (team != null) {
            for (String s : team.func_96670_d()) {
                ServerPlayerEntity serverplayerentity = this.func_152612_a(s);
                if (serverplayerentity == null || serverplayerentity == player) continue;
                serverplayerentity.func_145747_a(message);
            }
        }
    }

    public void func_177452_b(PlayerEntity player, ITextComponent message) {
        Team team = player.func_96124_cp();
        if (team == null) {
            this.func_148539_a(message);
        } else {
            for (int i = 0; i < this.field_72404_b.size(); ++i) {
                ServerPlayerEntity serverplayerentity = this.field_72404_b.get(i);
                if (serverplayerentity.func_96124_cp() == team) continue;
                serverplayerentity.func_145747_a(message);
            }
        }
    }

    public String[] func_72369_d() {
        String[] astring = new String[this.field_72404_b.size()];
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            astring[i] = this.field_72404_b.get(i).func_146103_bH().getName();
        }
        return astring;
    }

    public BanList func_152608_h() {
        return this.field_72401_g;
    }

    public IPBanList func_72363_f() {
        return this.field_72413_h;
    }

    public void func_152605_a(GameProfile profile) {
        this.field_72414_i.func_152687_a((UserListEntry)new OpEntry(profile, this.field_72400_f.func_110455_j(), this.field_72414_i.func_183026_b(profile)));
        ServerPlayerEntity serverplayerentity = this.func_177451_a(profile.getId());
        if (serverplayerentity != null) {
            this.func_187243_f(serverplayerentity);
        }
    }

    public void func_152610_b(GameProfile profile) {
        this.field_72414_i.func_152684_c((Object)profile);
        ServerPlayerEntity serverplayerentity = this.func_177451_a(profile.getId());
        if (serverplayerentity != null) {
            this.func_187243_f(serverplayerentity);
        }
    }

    private void func_187245_a(ServerPlayerEntity player, int permLevel) {
        if (player.field_71135_a != null) {
            byte b0 = permLevel <= 0 ? (byte)24 : (permLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permLevel)));
            player.field_71135_a.func_147359_a((IPacket<?>)new SEntityStatusPacket((Entity)player, b0));
        }
        this.field_72400_f.func_195571_aL().func_197051_a(player);
    }

    public boolean func_152607_e(GameProfile profile) {
        return !this.field_72409_l || this.field_72414_i.func_152692_d((Object)profile) || this.field_72411_j.func_152692_d((Object)profile);
    }

    public boolean func_152596_g(GameProfile profile) {
        return this.field_72414_i.func_152692_d((Object)profile) || this.field_72400_f.func_213199_b(profile) && this.field_72400_f.func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_76086_u() || this.field_72407_n;
    }

    @Nullable
    public ServerPlayerEntity func_152612_a(String username) {
        for (ServerPlayerEntity serverplayerentity : this.field_72404_b) {
            if (!serverplayerentity.func_146103_bH().getName().equalsIgnoreCase(username)) continue;
            return serverplayerentity;
        }
        return null;
    }

    public void func_148543_a(@Nullable PlayerEntity except, double x, double y, double z, double radius, DimensionType dimension, IPacket<?> packetIn) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            double d2;
            double d1;
            double d0;
            ServerPlayerEntity serverplayerentity = this.field_72404_b.get(i);
            if (serverplayerentity == except || serverplayerentity.field_71093_bK != dimension || !((d0 = x - serverplayerentity.func_226277_ct_()) * d0 + (d1 = y - serverplayerentity.func_226278_cu_()) * d1 + (d2 = z - serverplayerentity.func_226281_cx_()) * d2 < radius * radius)) continue;
            serverplayerentity.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_72389_g() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.func_72391_b(this.field_72404_b.get(i));
        }
    }

    public WhiteList func_152599_k() {
        return this.field_72411_j;
    }

    public String[] func_152598_l() {
        return this.field_72411_j.func_152685_a();
    }

    public OpList func_152603_m() {
        return this.field_72414_i;
    }

    public String[] func_152606_n() {
        return this.field_72414_i.func_152685_a();
    }

    public void func_187244_a() {
    }

    public void func_72354_b(ServerPlayerEntity playerIn, ServerWorld worldIn) {
        WorldBorder worldborder = this.field_72400_f.func_71218_a(DimensionType.field_223227_a_).func_175723_af();
        playerIn.field_71135_a.func_147359_a((IPacket<?>)new SWorldBorderPacket(worldborder, SWorldBorderPacket.Action.INITIALIZE));
        playerIn.field_71135_a.func_147359_a((IPacket<?>)new SUpdateTimePacket(worldIn.func_82737_E(), worldIn.func_72820_D(), worldIn.func_82736_K().func_223586_b(GameRules.field_223607_j)));
        BlockPos blockpos = worldIn.func_175694_M();
        playerIn.field_71135_a.func_147359_a((IPacket<?>)new SSpawnPositionPacket(blockpos));
        if (worldIn.func_72896_J()) {
            playerIn.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(1, 0.0f));
            playerIn.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(7, worldIn.func_72867_j(1.0f)));
            playerIn.field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(8, worldIn.func_72819_i(1.0f)));
        }
    }

    public void func_72385_f(ServerPlayerEntity playerIn) {
        playerIn.func_71120_a(playerIn.field_71069_bz);
        playerIn.func_71118_n();
        playerIn.field_71135_a.func_147359_a((IPacket<?>)new SHeldItemChangePacket(playerIn.field_71071_by.field_70461_c));
    }

    public int func_72394_k() {
        return this.field_72404_b.size();
    }

    public int func_72352_l() {
        return this.field_72405_c;
    }

    public boolean func_72383_n() {
        return this.field_72409_l;
    }

    public void func_72371_a(boolean whitelistEnabled) {
        this.field_72409_l = whitelistEnabled;
    }

    public List<ServerPlayerEntity> func_72382_j(String address) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayerEntity serverplayerentity : this.field_72404_b) {
            if (!serverplayerentity.func_71114_r().equals(address)) continue;
            list.add(serverplayerentity);
        }
        return list;
    }

    public int func_72395_o() {
        return this.field_72402_d;
    }

    public MinecraftServer func_72365_p() {
        return this.field_72400_f;
    }

    public CompoundNBT func_72378_q() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_152604_a(GameType gameModeIn) {
        this.field_72410_m = gameModeIn;
    }

    private void func_72381_a(ServerPlayerEntity target, ServerPlayerEntity source, IWorld worldIn) {
        if (source != null) {
            target.field_71134_c.func_73076_a(source.field_71134_c.func_73081_b());
        } else if (this.field_72410_m != null) {
            target.field_71134_c.func_73076_a(this.field_72410_m);
        }
        target.field_71134_c.func_73077_b(worldIn.func_72912_H().func_76077_q());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72387_b(boolean p_72387_1_) {
        this.field_72407_n = p_72387_1_;
    }

    public void func_72392_r() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.field_72404_b.get((int)i).field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.server_shutdown", new Object[0]));
        }
    }

    public void func_148544_a(ITextComponent component, boolean isSystem) {
        this.field_72400_f.func_145747_a(component);
        ChatType chattype = isSystem ? ChatType.SYSTEM : ChatType.CHAT;
        this.func_148540_a((IPacket<?>)new SChatPacket(component, chattype));
    }

    public void func_148539_a(ITextComponent component) {
        this.func_148544_a(component, true);
    }

    public ServerStatisticsManager func_152602_a(PlayerEntity playerIn) {
        ServerStatisticsManager serverstatisticsmanager;
        UUID uuid = playerIn.func_110124_au();
        ServerStatisticsManager serverStatisticsManager = serverstatisticsmanager = uuid == null ? null : this.field_148547_k.get(uuid);
        if (serverstatisticsmanager == null) {
            File file3;
            File file1 = new File(this.field_72400_f.func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "stats");
            File file2 = new File(file1, uuid + ".json");
            if (!file2.exists() && (file3 = new File(file1, playerIn.func_200200_C_().getString() + ".json")).exists() && file3.isFile()) {
                file3.renameTo(file2);
            }
            serverstatisticsmanager = new ServerStatisticsManager(this.field_72400_f, file2);
            this.field_148547_k.put(uuid, serverstatisticsmanager);
        }
        return serverstatisticsmanager;
    }

    public PlayerAdvancements func_192054_h(ServerPlayerEntity p_192054_1_) {
        UUID uuid = p_192054_1_.func_110124_au();
        PlayerAdvancements playeradvancements = this.field_192055_p.get(uuid);
        if (playeradvancements == null) {
            File file1 = new File(this.field_72400_f.func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "advancements");
            File file2 = new File(file1, uuid + ".json");
            playeradvancements = new PlayerAdvancements(this.field_72400_f, file2, p_192054_1_);
            this.field_192055_p.put(uuid, playeradvancements);
        }
        playeradvancements.func_192739_a(p_192054_1_);
        return playeradvancements;
    }

    public void func_217884_a(int viewDistanceIn) {
        this.field_72402_d = viewDistanceIn;
        this.func_148540_a((IPacket<?>)new SUpdateViewDistancePacket(viewDistanceIn));
        for (ServerWorld serverworld : this.field_72400_f.func_212370_w()) {
            if (serverworld == null) continue;
            serverworld.func_72863_F().func_217219_a(viewDistanceIn);
        }
    }

    public List<ServerPlayerEntity> func_181057_v() {
        return this.playersView;
    }

    @Nullable
    public ServerPlayerEntity func_177451_a(UUID playerUUID) {
        return this.field_177454_f.get(playerUUID);
    }

    public boolean func_183023_f(GameProfile profile) {
        return false;
    }

    public void func_193244_w() {
        for (PlayerAdvancements playeradvancements : this.field_192055_p.values()) {
            playeradvancements.func_193766_b();
        }
        this.func_148540_a((IPacket<?>)new STagsListPacket(this.field_72400_f.func_199731_aO()));
        SUpdateRecipesPacket supdaterecipespacket = new SUpdateRecipesPacket(this.field_72400_f.func_199529_aN().func_199510_b());
        for (ServerPlayerEntity serverplayerentity : this.field_72404_b) {
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)supdaterecipespacket);
            serverplayerentity.func_192037_E().func_192826_c(serverplayerentity);
        }
    }

    public boolean func_206257_x() {
        return this.field_72407_n;
    }

    public boolean addPlayer(ServerPlayerEntity player) {
        return DimensionManager.rebuildPlayerMap((PlayerList)this, (boolean)this.field_72404_b.add(player));
    }

    public boolean removePlayer(ServerPlayerEntity player) {
        return DimensionManager.rebuildPlayerMap((PlayerList)this, (boolean)this.field_72404_b.remove((Object)player));
    }
}

