/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TagsProvider<T>
implements IDataProvider {
    private static final Logger field_200436_d = LogManager.getLogger();
    private static final Gson field_200437_e = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200433_a;
    protected final Registry<T> field_200435_c;
    protected final Map<Tag<T>, Tag.Builder<T>> field_200434_b = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator generatorIn, Registry<T> registryIn) {
        this.field_200433_a = generatorIn;
        this.field_200435_c = registryIn;
    }

    protected abstract void func_200432_c();

    public void func_200398_a(DirectoryCache cache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        TagCollection tagcollection = new TagCollection(p_200428_0_ -> Optional.empty(), "", false, "generated");
        Map map = this.field_200434_b.entrySet().stream().collect(Collectors.toMap(p_223475_0_ -> ((Tag)p_223475_0_.getKey()).func_199886_b(), Map.Entry::getValue));
        tagcollection.func_219779_a(map);
        tagcollection.func_200039_c().forEach((p_223474_2_, p_223474_3_) -> {
            JsonObject jsonobject = p_223474_3_.func_200571_a(this.field_200435_c::func_177774_c);
            Path path = this.func_200431_a((ResourceLocation)p_223474_2_);
            if (path == null) {
                return;
            }
            try {
                String s = field_200437_e.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                field_200436_d.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
        this.func_200429_a(tagcollection);
    }

    protected abstract void func_200429_a(TagCollection<T> var1);

    protected abstract Path func_200431_a(ResourceLocation var1);

    protected Tag.Builder<T> func_200426_a(Tag<T> tagIn) {
        return this.field_200434_b.computeIfAbsent(tagIn, p_200427_0_ -> Tag.Builder.func_200047_a());
    }
}

