/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelShapes {
    private final Map<BlockState, IBakedModel> field_178129_a = Maps.newIdentityHashMap();
    private final ModelManager field_178128_c;

    public BlockModelShapes(ModelManager manager) {
        this.field_178128_c = manager;
    }

    @Deprecated
    public TextureAtlasSprite func_178122_a(BlockState state) {
        return this.func_178125_b(state).getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    public TextureAtlasSprite getTexture(BlockState state, World world, BlockPos pos) {
        IModelData data = ModelDataManager.getModelData((World)world, (BlockPos)pos);
        return this.func_178125_b(state).getParticleTexture((IModelData)(data == null ? EmptyModelData.INSTANCE : data));
    }

    public IBakedModel func_178125_b(BlockState state) {
        IBakedModel ibakedmodel = this.field_178129_a.get((Object)state);
        if (ibakedmodel == null) {
            ibakedmodel = this.field_178128_c.func_174951_a();
        }
        return ibakedmodel;
    }

    public ModelManager func_178126_b() {
        return this.field_178128_c;
    }

    public void func_178124_c() {
        this.field_178129_a.clear();
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(p_209551_1_ -> {
                IBakedModel ibakedmodel = this.field_178129_a.put((BlockState)((Object)p_209551_1_), this.field_178128_c.func_174953_a(BlockModelShapes.func_209554_c(p_209551_1_)));
            });
        }
    }

    public static ModelResourceLocation func_209554_c(BlockState state) {
        return BlockModelShapes.func_209553_a(Registry.field_212618_g.func_177774_c((Object)state.func_177230_c()), state);
    }

    public static ModelResourceLocation func_209553_a(ResourceLocation location, BlockState state) {
        return new ModelResourceLocation(location, BlockModelShapes.func_209552_a(state.func_206871_b()));
    }

    public static String func_209552_a(Map<IProperty<?>, Comparable<?>> propertyValues) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : propertyValues.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(',');
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append('=');
            stringbuilder.append(BlockModelShapes.func_209555_a(iproperty, entry.getValue()));
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String func_209555_a(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }
}

