/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import me.shedaniel.lightoverlay.LightOverlayCloth;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL11;

public class LightOverlayClient {
    static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    private static final String KEYBIND_CATEGORY = "key.lightoverlay-forge.category";
    private static final ResourceLocation ENABLE_OVERLAY_KEYBIND = new ResourceLocation("lightoverlay-forge", "enable_overlay");
    private static final ResourceLocation INCREASE_REACH_KEYBIND = new ResourceLocation("lightoverlay-forge", "increase_reach");
    private static final ResourceLocation DECREASE_REACH_KEYBIND = new ResourceLocation("lightoverlay-forge", "decrease_reach");
    private static final ResourceLocation INCREASE_LINE_WIDTH_KEYBIND = new ResourceLocation("lightoverlay-forge", "increase_line_width");
    private static final ResourceLocation DECREASE_LINE_WIDTH_KEYBIND = new ResourceLocation("lightoverlay-forge", "decrease_line_width");
    static int reach = 12;
    static int crossLevel = 7;
    static boolean showNumber = false;
    static boolean smoothLines = true;
    static boolean underwater = false;
    static EntityType<Entity> testingEntityType;
    static float lineWidth;
    static int yellowColor;
    static int redColor;
    static File configFile;
    private static KeyBinding enableOverlay;
    private static KeyBinding increaseReach;
    private static KeyBinding decreaseReach;
    private static KeyBinding increaseLineWidth;
    private static KeyBinding decreaseLineWidth;
    private static boolean enabled;
    private static int threadNumber;
    private static final ExecutorService EXECUTOR;
    private static final List<ChunkPos> POS;
    private static final Map<ChunkPos, Map<Long, Object>> CHUNK_MAP;
    private static long ticks;

    public static void register() {
        LightOverlayClient.loadConfig(configFile);
        testingEntityType = EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MONSTER).func_220321_a(0.0f, 0.0f).func_200706_c().func_206830_a(null);
        enableOverlay = LightOverlayClient.registerKeybind(ENABLE_OVERLAY_KEYBIND, InputMappings.Type.KEYSYM, 296, KEYBIND_CATEGORY);
        increaseReach = LightOverlayClient.registerKeybind(INCREASE_REACH_KEYBIND, InputMappings.Type.KEYSYM, -1, KEYBIND_CATEGORY);
        decreaseReach = LightOverlayClient.registerKeybind(DECREASE_REACH_KEYBIND, InputMappings.Type.KEYSYM, -1, KEYBIND_CATEGORY);
        increaseLineWidth = LightOverlayClient.registerKeybind(INCREASE_LINE_WIDTH_KEYBIND, InputMappings.Type.KEYSYM, -1, KEYBIND_CATEGORY);
        decreaseLineWidth = LightOverlayClient.registerKeybind(DECREASE_LINE_WIDTH_KEYBIND, InputMappings.Type.KEYSYM, -1, KEYBIND_CATEGORY);
        MinecraftForge.EVENT_BUS.register(LightOverlayClient.class);
        try {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> LightOverlayCloth.register());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CrossType getCrossType(BlockPos pos, BlockPos down, IBlockReader reader, IWorldLightListener block, IWorldLightListener sky, ISelectionContext selectionContext) {
        BlockState blockBelowState = reader.func_180495_p(down);
        BlockState blockUpperState = reader.func_180495_p(pos);
        VoxelShape upperCollisionShape = blockUpperState.func_215685_b(reader, pos, selectionContext);
        if (!underwater && !blockUpperState.func_204520_s().func_206888_e()) {
            return CrossType.NONE;
        }
        if (Block.func_208061_a((VoxelShape)upperCollisionShape, (Direction)Direction.UP)) {
            return CrossType.NONE;
        }
        if (blockUpperState.func_185897_m()) {
            return CrossType.NONE;
        }
        if (upperCollisionShape.func_197758_c(Direction.Axis.Y) > 0.0) {
            return CrossType.NONE;
        }
        if (blockUpperState.func_177230_c().func_203417_a(BlockTags.field_203437_y)) {
            return CrossType.NONE;
        }
        if (!blockBelowState.func_215688_a(reader, down, testingEntityType)) {
            return CrossType.NONE;
        }
        if (block.func_215611_b(pos) > crossLevel) {
            return CrossType.NONE;
        }
        if (sky.func_215611_b(pos) > crossLevel) {
            return CrossType.YELLOW;
        }
        return CrossType.RED;
    }

    public static int getCrossLevel(BlockPos pos, BlockPos down, IBlockReader reader, IWorldLightListener light, ISelectionContext context) {
        BlockState blockBelowState = reader.func_180495_p(down);
        BlockState blockUpperState = reader.func_180495_p(pos);
        VoxelShape collisionShape = blockBelowState.func_215685_b(reader, down, context);
        VoxelShape upperCollisionShape = blockUpperState.func_215685_b(reader, pos, context);
        if (!underwater && !blockUpperState.func_204520_s().func_206888_e()) {
            return -1;
        }
        if (!blockBelowState.func_204520_s().func_206888_e()) {
            return -1;
        }
        if (blockBelowState.isAir(reader, down)) {
            return -1;
        }
        if (Block.func_208061_a((VoxelShape)upperCollisionShape, (Direction)Direction.DOWN)) {
            return -1;
        }
        return light.func_215611_b(pos);
    }

    public static void renderCross(ActiveRenderInfo info, Tessellator tessellator, BufferBuilder buffer, World world, BlockPos pos, int color, ISelectionContext context) {
        double d0 = info.func_216785_c().field_72450_a;
        double d1 = info.func_216785_c().field_72448_b - 0.005;
        VoxelShape upperOutlineShape = world.func_180495_p(pos).func_215700_a((IBlockReader)world, pos, context);
        if (!upperOutlineShape.func_197766_b()) {
            d1 -= upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        double d2 = info.func_216785_c().field_72449_c;
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        buffer.func_225582_a_((double)pos.func_177958_n() + 0.01 - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() + 0.01 - d2).func_225586_a_(red, green, blue, 255).func_181675_d();
        buffer.func_225582_a_((double)pos.func_177958_n() - 0.01 + 1.0 - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() - 0.01 + 1.0 - d2).func_225586_a_(red, green, blue, 255).func_181675_d();
        buffer.func_225582_a_((double)pos.func_177958_n() - 0.01 + 1.0 - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() + 0.01 - d2).func_225586_a_(red, green, blue, 255).func_181675_d();
        buffer.func_225582_a_((double)pos.func_177958_n() + 0.01 - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() - 0.01 + 1.0 - d2).func_225586_a_(red, green, blue, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderLevel(Minecraft minecraft, ActiveRenderInfo info, World world, BlockPos pos, BlockPos down, int level, ISelectionContext context) {
        String string_1 = String.valueOf(level);
        FontRenderer fontRenderer = minecraft.field_71466_p;
        double double_4 = info.func_216785_c().field_72450_a;
        double double_5 = info.func_216785_c().field_72448_b;
        VoxelShape upperOutlineShape = world.func_180495_p(down).func_215700_a((IBlockReader)world, down, context);
        if (!upperOutlineShape.func_197766_b()) {
            double_5 += 1.0 - upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        double double_6 = info.func_216785_c().field_72449_c;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)((double)((float)pos.func_177958_n() + 0.5f) - double_4)), (float)((float)((double)pos.func_177956_o() - double_5) + 0.005f), (float)((float)((double)((float)pos.func_177952_p() + 0.5f) - double_6)));
        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        float size = 0.07f;
        RenderSystem.scalef((float)(-size), (float)(-size), (float)size);
        float float_3 = (float)(-fontRenderer.func_78256_a(string_1)) / 2.0f + 0.4f;
        RenderSystem.enableAlphaTest();
        IRenderTypeBuffer.Impl vertexConsumerProvider$Immediate_1 = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        fontRenderer.func_228079_a_(string_1, float_3, -3.5f, level > crossLevel ? -16505852 : -9236207, false, TransformationMatrix.func_227983_a_().func_227988_c_(), (IRenderTypeBuffer)vertexConsumerProvider$Immediate_1, false, 0, 0xF000F0);
        vertexConsumerProvider$Immediate_1.func_228461_a_();
        RenderSystem.popMatrix();
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void handleInput(InputEvent.KeyInputEvent event) {
        if (enableOverlay.func_151468_f()) {
            boolean bl = enabled = !enabled;
        }
        if (increaseReach.func_151468_f()) {
            if (reach < 64) {
                ++reach;
            }
            try {
                LightOverlayClient.saveConfig(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("text.lightoverlay-forge.current_reach", new Object[]{reach}), false);
        }
        if (decreaseReach.func_151468_f()) {
            if (reach > 1) {
                --reach;
            }
            try {
                LightOverlayClient.saveConfig(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("text.lightoverlay-forge.current_reach", new Object[]{reach}), false);
        }
        if (increaseLineWidth.func_151468_f()) {
            if (lineWidth < 7.0f) {
                lineWidth += 0.1f;
            }
            try {
                LightOverlayClient.saveConfig(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("text.lightoverlay-forge.current_line_width", new Object[]{FORMAT.format(lineWidth)}), false);
        }
        if (decreaseLineWidth.func_151468_f()) {
            if (lineWidth > 1.0f) {
                lineWidth -= 0.1f;
            }
            try {
                LightOverlayClient.saveConfig(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("text.lightoverlay-forge.current_line_width", new Object[]{FORMAT.format(lineWidth)}), false);
        }
    }

    public static void queueChunkAndNear(ChunkPos pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                LightOverlayClient.queueChunk(new ChunkPos(pos.field_77276_a + xOffset, pos.field_77275_b + zOffset));
            }
        }
    }

    public static void queueChunk(ChunkPos pos) {
        if (!POS.contains(pos)) {
            POS.add(0, pos);
        }
    }

    public static int getChunkRange() {
        return Math.max(MathHelper.func_76123_f((float)((float)reach / 16.0f)), 1);
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                Minecraft minecraft = Minecraft.func_71410_x();
                ++ticks;
                if (minecraft.field_71439_g == null || !enabled) {
                    POS.clear();
                    CHUNK_MAP.clear();
                } else {
                    ClientPlayerEntity player = minecraft.field_71439_g;
                    ClientWorld world = minecraft.field_71441_e;
                    ISelectionContext selectionContext = ISelectionContext.func_216374_a((Entity)player);
                    Vec3d[] playerPos = new Vec3d[]{null};
                    int playerPosX = (int)player.func_226277_ct_() >> 4;
                    int playerPosZ = (int)player.func_226281_cx_() >> 4;
                    if (ticks % 20L == 0L) {
                        for (int chunkX = playerPosX - LightOverlayClient.getChunkRange(); chunkX <= playerPosX + LightOverlayClient.getChunkRange(); ++chunkX) {
                            for (int chunkZ = playerPosZ - LightOverlayClient.getChunkRange(); chunkZ <= playerPosZ + LightOverlayClient.getChunkRange(); ++chunkZ) {
                                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                                if (CHUNK_MAP.containsKey(chunkPos)) continue;
                                LightOverlayClient.queueChunk(chunkPos);
                            }
                        }
                    }
                    if (!POS.isEmpty()) {
                        if (playerPos[0] == null) {
                            playerPos[0] = player.func_213303_ch();
                        }
                        ChunkPos pos = POS.stream().min(Comparator.comparingDouble(value -> value.func_180331_a(8, 0, 8).func_218140_a(playerPos[0].field_72450_a, 0.0, playerPos[0].field_72449_c, false))).get();
                        EXECUTOR.submit(() -> {
                            if (MathHelper.func_76130_a((int)(pos.field_77276_a - playerPosX)) <= LightOverlayClient.getChunkRange() && MathHelper.func_76130_a((int)(pos.field_77275_b - playerPosZ)) <= LightOverlayClient.getChunkRange()) {
                                LightOverlayClient.calculateChunk(world.func_72863_F().func_212849_a_(pos.field_77276_a, pos.field_77275_b, ChunkStatus.field_222617_m, false), (World)world, pos, selectionContext);
                            } else {
                                CHUNK_MAP.remove(pos);
                            }
                        });
                        POS.remove(pos);
                    }
                    Iterator<Map.Entry<ChunkPos, Map<Long, Object>>> chunkMapIterator = CHUNK_MAP.entrySet().iterator();
                    while (chunkMapIterator.hasNext()) {
                        Map.Entry<ChunkPos, Map<Long, Object>> pos = chunkMapIterator.next();
                        if (MathHelper.func_76130_a((int)(pos.getKey().field_77276_a - playerPosX)) <= LightOverlayClient.getChunkRange() * 2 && MathHelper.func_76130_a((int)(pos.getKey().field_77275_b - playerPosZ)) <= LightOverlayClient.getChunkRange() * 2) continue;
                        chunkMapIterator.remove();
                    }
                }
            }
            catch (Exception e) {
                LogManager.getLogger().throwing((Throwable)e);
            }
        }
    }

    private static void calculateChunk(Chunk chunk, World world, ChunkPos chunkPos, ISelectionContext selectionContext) {
        HashMap map = Maps.newHashMap();
        if (chunk != null) {
            IWorldLightListener block = chunk.func_217307_e().func_215569_a(LightType.BLOCK);
            IWorldLightListener sky = showNumber ? null : chunk.func_217307_e().func_215569_a(LightType.SKY);
            for (BlockPos pos : BlockPos.func_191531_b((int)chunkPos.func_180334_c(), (int)0, (int)chunkPos.func_180333_d(), (int)chunkPos.func_180332_e(), (int)256, (int)chunkPos.func_180330_f())) {
                CrossType type;
                BlockPos down = pos.func_177977_b();
                if (showNumber) {
                    int level = LightOverlayClient.getCrossLevel(pos, down, (IBlockReader)chunk, block, selectionContext);
                    if (level < 0) continue;
                    map.put(pos.func_218275_a(), level);
                    continue;
                }
                Biome biome = world.func_225523_d_().func_226836_a_(pos);
                if (!(biome.func_76741_f() > 0.0f) || biome.func_76747_a(EntityClassification.MONSTER).isEmpty() || (type = LightOverlayClient.getCrossType(pos, down, (IBlockReader)chunk, block, sky, selectionContext)) == CrossType.NONE) continue;
                map.put(pos.func_218275_a(), type);
            }
        }
        CHUNK_MAP.put(chunkPos, map);
    }

    public static void renderWorldLast() {
        if (enabled) {
            RenderSystem.pushMatrix();
            Minecraft client = Minecraft.func_71410_x();
            ClientPlayerEntity playerEntity = client.field_71439_g;
            int playerPosX = (int)playerEntity.func_226277_ct_() >> 4;
            int playerPosZ = (int)playerEntity.func_226281_cx_() >> 4;
            ISelectionContext selectionContext = ISelectionContext.func_216374_a((Entity)playerEntity);
            ClientWorld world = client.field_71441_e;
            BlockPos playerPos = playerEntity.func_180425_c();
            ActiveRenderInfo info = client.field_71460_t.func_215316_n();
            if (showNumber) {
                RenderSystem.enableTexture();
                RenderSystem.depthMask((boolean)true);
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (Map.Entry<ChunkPos, Map<Long, Object>> entry : CHUNK_MAP.entrySet()) {
                    if (MathHelper.func_76130_a((int)(entry.getKey().field_77276_a - playerPosX)) > LightOverlayClient.getChunkRange() || MathHelper.func_76130_a((int)(entry.getKey().field_77275_b - playerPosZ)) > LightOverlayClient.getChunkRange()) continue;
                    for (Map.Entry<Long, Object> objectEntry : entry.getValue().entrySet()) {
                        if (!(objectEntry.getValue() instanceof Integer)) continue;
                        mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getKey()), BlockPos.func_218274_c((long)objectEntry.getKey()), BlockPos.func_218282_d((long)objectEntry.getKey()));
                        if (!mutable.func_218141_a((Vec3i)playerPos, (double)reach)) continue;
                        BlockPos down = mutable.func_177977_b();
                        LightOverlayClient.renderLevel(client, info, (World)world, (BlockPos)mutable, down, (Integer)objectEntry.getValue(), selectionContext);
                    }
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
                RenderSystem.shadeModel((int)7425);
                RenderSystem.enableAlphaTest();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.disableTexture();
                RenderSystem.disableBlend();
                if (smoothLines) {
                    GL11.glEnable((int)2848);
                }
                RenderSystem.lineWidth((float)lineWidth);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (Map.Entry<ChunkPos, Map<Long, Object>> entry : CHUNK_MAP.entrySet()) {
                    if (MathHelper.func_76130_a((int)(entry.getKey().field_77276_a - playerPosX)) > LightOverlayClient.getChunkRange() || MathHelper.func_76130_a((int)(entry.getKey().field_77275_b - playerPosZ)) > LightOverlayClient.getChunkRange()) continue;
                    for (Map.Entry<Long, Object> objectEntry : entry.getValue().entrySet()) {
                        if (!(objectEntry.getValue() instanceof CrossType)) continue;
                        mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getKey()), BlockPos.func_218274_c((long)objectEntry.getKey()), BlockPos.func_218282_d((long)objectEntry.getKey()));
                        if (!mutable.func_218141_a((Vec3i)playerPos, (double)reach)) continue;
                        BlockPos down = mutable.func_177977_b();
                        int color = objectEntry.getValue() == CrossType.RED ? redColor : yellowColor;
                        LightOverlayClient.renderCross(info, tessellator, buffer, (World)world, (BlockPos)mutable, color, selectionContext);
                    }
                }
                RenderSystem.enableBlend();
                RenderSystem.enableTexture();
                RenderSystem.shadeModel((int)7424);
                if (smoothLines) {
                    GL11.glDisable((int)2848);
                }
            }
            RenderSystem.popMatrix();
        }
    }

    private static KeyBinding registerKeybind(ResourceLocation resourceLocation, InputMappings.Type type, int keyCode, String category) {
        KeyBinding keyBinding = new KeyBinding("key." + resourceLocation.func_110624_b() + "." + resourceLocation.func_110623_a(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, type, keyCode, category);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            if (!file.exists() || !file.canRead()) {
                LightOverlayClient.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            smoothLines = ((String)properties.computeIfAbsent("smoothLines", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            LightOverlayClient.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            showNumber = false;
            smoothLines = true;
            underwater = false;
            try {
                LightOverlayClient.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("smoothLines=" + smoothLines).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.close();
    }

    public static void processPacket(IPacket<?> packet) {
        if (packet instanceof SChangeBlockPacket) {
            LightOverlayClient.queueChunkAndNear(new ChunkPos(((SChangeBlockPacket)packet).func_179827_b()));
        } else if (packet instanceof SChunkDataPacket) {
            LightOverlayClient.queueChunkAndNear(new ChunkPos(((SChunkDataPacket)packet).func_149273_e(), ((SChunkDataPacket)packet).func_149271_f()));
        } else if (packet instanceof SMultiBlockChangePacket) {
            ChunkPos chunkPos = (ChunkPos)ObfuscationReflectionHelper.getPrivateValue(SMultiBlockChangePacket.class, (Object)((SMultiBlockChangePacket)packet), (String)"field_148925_b");
            LightOverlayClient.queueChunkAndNear(new ChunkPos(chunkPos.field_77276_a, chunkPos.field_77275_b));
        }
    }

    static {
        lineWidth = 1.0f;
        yellowColor = 0xFFFF00;
        redColor = 0xFF0000;
        configFile = new File(new File(Minecraft.func_71410_x().field_71412_D, "config"), "lightoverlay.properties");
        enabled = false;
        threadNumber = 0;
        EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
            Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
            thread.setDaemon(true);
            return thread;
        });
        POS = Lists.newCopyOnWriteArrayList();
        CHUNK_MAP = Maps.newConcurrentMap();
        ticks = 0L;
    }

    private static enum CrossType {
        YELLOW,
        RED,
        NONE;

    }
}

