/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.translate.StyleUtils;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public abstract class FluxNetworkBlock
extends Block {
    public FluxNetworkBlock(Block.Properties props) {
        super(props);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(hand).func_77973_b() instanceof FluxConfiguratorItem) {
            return ActionResultType.FAIL;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileFluxCore) {
            TileFluxCore fluxCore = (TileFluxCore)tileEntity;
            if (fluxCore.playerUsing.size() > 0) {
                player.func_146105_b(StyleUtils.getErrorStyle(FluxTranslate.ACCESS_OCCUPY_KEY), true);
                return ActionResultType.SUCCESS;
            }
            if (fluxCore.canAccess(player)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)fluxCore, buf -> {
                    buf.writeBoolean(true);
                    buf.func_179255_a(pos);
                });
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b(StyleUtils.getErrorStyle(FluxTranslate.ACCESS_DENIED_KEY), true);
        }
        return ActionResultType.SUCCESS;
    }

    public ResourceLocation func_220068_i() {
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        this.readDataFromStack(stack, pos, worldIn);
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileFluxCore) {
            TileFluxCore fluxCore = (TileFluxCore)tileEntity;
            if (placer instanceof PlayerEntity) {
                fluxCore.playerUUID = PlayerEntity.func_146094_a((GameProfile)((PlayerEntity)placer).func_146103_bH());
            }
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluxCore) {
            TileFluxCore tileFluxCore = (TileFluxCore)tile;
            if (tileFluxCore.canAccess(player)) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                FluxNetworkBlock.writeDataToStack(stack, pos, world);
                float motion = 0.7f;
                double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
                double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
                double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
                ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, stack);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                world.func_217376_c((Entity)entityItem);
                return true;
            }
            player.func_146105_b(StyleUtils.getErrorStyle(FluxTranslate.REMOVAL_DENIED_KEY), true);
        }
        return false;
    }

    public static void writeDataToStack(ItemStack stack, BlockPos pos, World world) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluxCore) {
            TileFluxCore t = (TileFluxCore)tile;
            CompoundNBT tag = stack.func_190925_c("FluxData");
            t.writeCustomNBT(tag, NBTType.TILE_DROP);
        }
    }

    protected void readDataFromStack(ItemStack stack, BlockPos pos, World world) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFluxCore && stack.func_77942_o()) {
            TileFluxCore t = (TileFluxCore)tile;
            CompoundNBT tag = stack.func_179543_a("FluxData");
            if (tag != null) {
                t.readCustomNBT(tag, NBTType.TILE_DROP);
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

