/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.button.BatchEditButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.popups.PopUpConnectionEdit;
import sonar.fluxnetworks.client.gui.tab.GuiTabSelection;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.BatchEditingPacket;
import sonar.fluxnetworks.common.network.ConnectionUpdateRequestPacket;
import sonar.fluxnetworks.common.network.NetworkUpdateRequestPacket;

public class GuiTabConnections
extends GuiTabPages<IFluxConnector> {
    public InvisibleButton redirectButton;
    private List<BatchEditButton> editButtons = new ArrayList<BatchEditButton>();
    public List<IFluxConnector> batchConnections = new ArrayList<IFluxConnector>();
    public IFluxConnector singleConnection;
    public BatchEditButton clear;
    public BatchEditButton edit;
    public BatchEditButton disconnect;
    private int timer = 3;

    public GuiTabConnections(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 19;
        this.gridPerPage = 7;
        this.elementHeight = 18;
        this.elementWidth = 146;
        PacketHandler.INSTANCE.sendToServer((Object)new NetworkUpdateRequestPacket(this.network.getNetworkID(), NBTType.NETWORK_CONNECTIONS));
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_CONNECTION;
    }

    @Override
    public void init() {
        super.init();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_CONNECTION, this.navigationTabs);
        this.editButtons.clear();
        this.buttonLists.add(this.editButtons);
        if (!this.networkValid) {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabConnections.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.addButton((Widget)this.redirectButton);
        } else {
            this.clear = new BatchEditButton(118, 8, 0, FluxTranslate.BATCH_CLEAR_BUTTON.t()).setUnclickable();
            this.edit = new BatchEditButton(132, 8, 1, FluxTranslate.BATCH_EDIT_BUTTON.t()).setUnclickable();
            this.disconnect = new BatchEditButton(146, 8, 2, FluxTranslate.BATCH_DISCONNECT_BUTTON.t()).setUnclickable();
            this.editButtons.add(this.clear);
            this.editButtons.add(this.edit);
            this.editButtons.add(this.disconnect);
        }
    }

    @Override
    protected void onElementClicked(IFluxConnector element, int mouseButton) {
        if (mouseButton == 0 && this.batchConnections.size() == 0 && element.isChunkLoaded()) {
            this.singleConnection = element;
            this.openPopUp(new PopUpConnectionEdit(this, false, this.player, this.connector));
        }
        if (mouseButton == 1 || mouseButton == 0 && this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                this.batchConnections.remove(element);
                if (this.batchConnections.size() <= 0) {
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                }
            } else if (element.isChunkLoaded()) {
                this.batchConnections.add(element);
                this.clear.clickable = true;
                this.edit.clickable = true;
                this.disconnect.clickable = true;
            }
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.networkValid) {
            if (this.batchConnections.size() > 0) {
                this.font.func_211126_b(FluxTranslate.SELECTED.t() + ": " + TextFormatting.AQUA + this.batchConnections.size(), 20.0f, 10.0f, 0xFFFFFF);
            } else {
                this.font.func_211126_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + FluxTranslate.SORTING_SMART.t(), 19.0f, 10.0f, 0xFFFFFF);
            }
            super.drawForegroundLayer(mouseX, mouseY);
            if (!this.hasActivePopup()) {
                this.drawCenteredString(this.font, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 88, 165, 0xFFFFFF);
            }
        } else {
            super.drawForegroundLayer(mouseX, mouseY);
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void renderElement(IFluxConnector element, int x, int y) {
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(ScreenUtils.GUI_BAR);
        int fontColor = 0xFFFFFF;
        int color = element.getConnectionType().color;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                GuiTabConnections.fill((int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-855638017);
                GuiTabConnections.fill((int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-855638017);
                RenderSystem.color3f((float)red, (float)green, (float)blue);
                this.blit(x, y, 0, 32, this.elementWidth, this.elementHeight);
            } else {
                GuiTabConnections.fill((int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-1436524448);
                GuiTabConnections.fill((int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-1436524448);
                RenderSystem.color3f((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f));
                this.blit(x, y, 0, 32, this.elementWidth, this.elementHeight);
                fontColor = 0xD0D0D0;
            }
        } else {
            RenderSystem.color3f((float)red, (float)green, (float)blue);
            this.blit(x, y, 0, 32, this.elementWidth, this.elementHeight);
        }
        if (element.isChunkLoaded()) {
            this.font.func_211126_b(element.getCustomName(), (float)(x + 21), (float)(y + 2), fontColor);
            RenderSystem.scaled((double)0.625, (double)0.625, (double)0.625);
            this.font.func_211126_b(FluxUtils.getTransferInfo(element.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), element.getChange()), (float)((int)((double)(x + 21) * 1.6)), (float)((int)((double)(y + 11) * 1.6)), fontColor);
            RenderSystem.scaled((double)1.6, (double)1.6, (double)1.6);
        } else {
            this.font.func_211126_b(element.getCustomName(), (float)(x + 21), (float)(y + 5), 0x808080);
        }
        if (this.currentPopUp == null) {
            this.screenUtils.renderItemStack(element.getDisplayStack(), x + 2, y + 1);
        }
    }

    @Override
    public void renderElementTooltip(IFluxConnector element, int mouseX, int mouseY) {
        if (!this.hasActivePopup()) {
            GlStateManager.func_227626_N_();
            this.screenUtils.drawHoverTooltip(this.getFluxInfo(element), mouseX + 4, mouseY - 16);
            GlStateManager.func_227627_O_();
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof BatchEditButton) {
            switch (button.id) {
                case 0: {
                    this.batchConnections.clear();
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                    break;
                }
                case 1: {
                    this.openPopUp(new PopUpConnectionEdit(this, true, this.player, this.connector));
                    break;
                }
                case 2: {
                    List<Coord4D> list = this.batchConnections.stream().map(IFluxConnector::getCoords).collect(Collectors.toList());
                    boolean[] b = new boolean[]{false, false, false, false, false, false, true};
                    PacketHandler.INSTANCE.sendToServer((Object)new BatchEditingPacket(this.network.getNetworkID(), list, new CompoundNBT(), b));
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.networkValid) {
            return;
        }
        if (this.timer == 4) {
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
        }
        if (this.timer % 5 == 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new ConnectionUpdateRequestPacket(this.network.getNetworkID(), this.current.stream().map(IFluxConnector::getCoords).collect(Collectors.toList())));
        }
        ++this.timer;
        this.timer %= 20;
        if (FluxNetworks.proxy.getFeedback(true) == EnumFeedbackInfo.SUCCESS) {
            this.closePopUp();
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
        }
        if (FluxNetworks.proxy.getFeedback(true) == EnumFeedbackInfo.SUCCESS_2) {
            this.closePopUp();
            this.elements.removeAll(this.batchConnections);
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
            if (this.connector instanceof IFluxConnector && this.elements.stream().noneMatch(f -> f.getCoords().equals(((IFluxConnector)this.connector).getCoords()))) {
                Minecraft.func_71410_x().field_71462_r = new GuiTabSelection(this.player, this.connector);
            }
            this.page = Math.min(this.page, this.pages);
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(IFluxConnector::isChunkLoaded).reversed().thenComparing(f -> f.getConnectionType().isStorage()).thenComparing(f -> f.getConnectionType().canAddEnergy()).thenComparing(f -> f.getConnectionType().canRemoveEnergy()).thenComparing(p -> -p.getPriority()));
        this.refreshCurrentPageInternal();
    }
}

