/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.ConfigException;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.utils.config.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

final class Category {
    final String fullyQualifiedName;
    final String languageKeyPrefix;
    final String languageKey;
    final Class<?> clazz;
    final String comment;
    final String name;
    final List<Property> properties = new ArrayList<Property>();
    final Method onReload;
    final Method onReloadClient;

    Category(String fullyQualifiedNamePrefix, String languageKeyPrefix, Class<?> clazz, String comment, String name) {
        this.fullyQualifiedName = fullyQualifiedNamePrefix + name;
        this.languageKeyPrefix = languageKeyPrefix;
        this.languageKey = languageKeyPrefix + name;
        this.clazz = clazz;
        this.comment = comment;
        this.name = name;
        this.onReload = Category.getOnReloadMethod(clazz, "onReload");
        this.onReloadClient = Category.getOnReloadMethod(clazz, "onReloadClient");
    }

    void initialize(CommentedFileConfig config) {
        config.setComment(this.fullyQualifiedName, this.comment);
    }

    void onReload(boolean client) {
        Method method;
        Method method2 = method = client ? this.onReloadClient : this.onReload;
        if (method != null) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new ConfigException("Failed to reload configuration category", ex);
            }
        }
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    String getLanguageKeyPrefix() {
        return this.languageKey + ".";
    }

    private static Method getOnReloadMethod(Class<?> clazz, String name) {
        Method onReload;
        try {
            onReload = clazz.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        int modifiers = onReload.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || onReload.getReturnType() != Void.TYPE) {
            throw new ConfigException(name + " must be public static void");
        }
        return onReload;
    }
}

