/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.utils;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockUtils {
    public static boolean isBlockInWater(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_204520_s().func_206884_a(FluidTags.field_206959_a)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!world.func_204610_c(pos.func_177972_a(direction)).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlace(World world, PlayerEntity player, BlockPos pos, BlockState state) {
        ISelectionContext selectionContext = player == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)player);
        VoxelShape voxelshape = state.func_215685_b((IBlockReader)world, pos, selectionContext);
        VoxelShape offsetShape = world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos);
        return (offsetShape.func_197766_b() || world.func_180495_p(pos).func_185904_a().func_76222_j()) && state.func_196955_c((IWorldReader)world, pos) && world.func_195585_a(null, voxelshape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public static SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    public static boolean isPosNotTouchingBlock(IWorld world, BlockPos pos, Block blockToCheck, Direction ... blacklistedDirections) {
        for (Direction directions : Direction.values()) {
            List<Direction> blacklistedDirectionsList = Arrays.asList(blacklistedDirections);
            if (blacklistedDirectionsList.contains(directions) || world.func_180495_p(pos.func_177972_a(directions)).func_177230_c() != blockToCheck) continue;
            return false;
        }
        return true;
    }

    public static BlockState transferAllBlockStates(BlockState initial, BlockState after) {
        BlockState block = after;
        for (IProperty property : initial.func_177230_c().func_176194_O().func_177623_d()) {
            if (!after.func_196959_b(property) || initial.func_177229_b(property) == null) continue;
            block = (BlockState)block.func_206870_a(property, initial.func_177229_b(property));
        }
        return block;
    }
}

