/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teamabnormals.abnormals_core.client.renderer.AbnormalsBoatRenderer;
import com.teamabnormals.abnormals_core.client.tile.AbnormalsSignTileEntityRenderer;
import com.teamabnormals.abnormals_core.common.blocks.AbnormalsBeehiveBlock;
import com.teamabnormals.abnormals_core.common.network.MessageC2SEditSign;
import com.teamabnormals.abnormals_core.common.network.MessageS2CUpdateSign;
import com.teamabnormals.abnormals_core.common.network.MessageSOpenSignEditor;
import com.teamabnormals.abnormals_core.common.network.entity.MessageS2CEndimation;
import com.teamabnormals.abnormals_core.common.network.entity.MessageS2CTeleportEntity;
import com.teamabnormals.abnormals_core.common.network.particle.MessageC2S2CSpawnParticle;
import com.teamabnormals.abnormals_core.common.network.particle.MessageS2CSpawnParticle;
import com.teamabnormals.abnormals_core.core.config.ACConfig;
import com.teamabnormals.abnormals_core.core.examples.ExampleEntityRegistry;
import com.teamabnormals.abnormals_core.core.examples.ExampleTileEntityRegistry;
import com.teamabnormals.abnormals_core.core.library.Test;
import com.teamabnormals.abnormals_core.core.library.api.IAddToBiomes;
import com.teamabnormals.abnormals_core.core.library.api.ModLoadedLootCondition;
import com.teamabnormals.abnormals_core.core.library.endimator.EndimationDataManager;
import com.teamabnormals.abnormals_core.core.registry.LootInjectionRegistry;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="abnormals_core")
@Mod.EventBusSubscriber(modid="abnormals_core", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AbnormalsCore {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "abnormals_core";
    public static final String NETWORK_PROTOCOL = "AC1";
    public static final EndimationDataManager ENDIMATION_DATA_MANAGER = new EndimationDataManager();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("abnormals_core");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("abnormals_core", "net")).networkProtocolVersion(() -> "AC1").clientAcceptedVersions("AC1"::equals).serverAcceptedVersions("AC1"::equals).simpleChannel();

    public AbnormalsCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupMessages();
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)new ModLoadedLootCondition.Serializer());
        REGISTRY_HELPER.getDeferredEntityRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredTileEntityRegister().register(modEventBus);
        modEventBus.addListener(event -> {
            ModConfig config = event.getConfig();
            if (config.getSpec() == ACConfig.COMMON_SPEC) {
                ACConfig.ValuesHolder.updateCommonValuesFromConfig(config);
            }
        });
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::replaceBeehivePOI);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)ENDIMATION_DATA_MANAGER);
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(EventPriority.LOWEST, this::commonSetup);
            modEventBus.addListener(EventPriority.LOWEST, this::registerItemColors);
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ACConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ForgeRegistries.FEATURES.getValues().stream().filter(feature -> feature instanceof IAddToBiomes).forEach(feature -> ForgeRegistries.BIOMES.forEach(((IAddToBiomes)feature).processBiomeAddition()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ExampleEntityRegistry.BOAT.get()), AbnormalsBoatRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ExampleTileEntityRegistry.SIGN.get()), AbnormalsSignTileEntityRenderer::new);
    }

    @Test
    private void registerLootInjectors() {
        LootInjectionRegistry.LootInjector injector = new LootInjectionRegistry.LootInjector(MODID);
        injector.registerLootInjection(injector.buildLootBool("test", 1, 0), LootTables.field_186425_g, LootTables.field_186430_l);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        REGISTRY_HELPER.processSpawnEggColors(event);
    }

    private void replaceBeehivePOI(FMLCommonSetupEvent event) {
        ImmutableList BEEHIVES = (ImmutableList)ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof AbnormalsBeehiveBlock).collect(ImmutableList.toImmutableList());
        PointOfInterestType.field_226356_s_.field_221075_w = (Set)BlockTags.field_226151_aa_.func_199885_a().stream().flatMap(map -> map.func_176194_O().func_177619_a().stream()).collect(ImmutableSet.toImmutableSet());
        HashMap pointOfInterestTypeMap = new HashMap();
        BEEHIVES.stream().forEach(block -> block.func_176194_O().func_177619_a().forEach(state -> pointOfInterestTypeMap.put(state, PointOfInterestType.field_226356_s_)));
        PointOfInterestType.field_221073_u.putAll(pointOfInterestTypeMap);
    }

    private void setupMessages() {
        int id = -1;
        CHANNEL.messageBuilder(MessageS2CEndimation.class, id++).encoder(MessageS2CEndimation::serialize).decoder(MessageS2CEndimation::deserialize).consumer(MessageS2CEndimation::handle).add();
        CHANNEL.messageBuilder(MessageSOpenSignEditor.class, id++).encoder(MessageSOpenSignEditor::serialize).decoder(MessageSOpenSignEditor::deserialize).consumer(MessageSOpenSignEditor::handle).add();
        CHANNEL.messageBuilder(MessageC2SEditSign.class, id++).encoder(MessageC2SEditSign::serialize).decoder(MessageC2SEditSign::deserialize).consumer(MessageC2SEditSign::handle).add();
        CHANNEL.messageBuilder(MessageS2CUpdateSign.class, id++).encoder(MessageS2CUpdateSign::serialize).decoder(MessageS2CUpdateSign::deserialize).consumer(MessageS2CUpdateSign::handle).add();
        CHANNEL.messageBuilder(MessageS2CTeleportEntity.class, id++).encoder(MessageS2CTeleportEntity::serialize).decoder(MessageS2CTeleportEntity::deserialize).consumer(MessageS2CTeleportEntity::handle).add();
        CHANNEL.messageBuilder(MessageS2CSpawnParticle.class, id++).encoder(MessageS2CSpawnParticle::serialize).decoder(MessageS2CSpawnParticle::deserialize).consumer(MessageS2CSpawnParticle::handle).add();
        CHANNEL.messageBuilder(MessageC2S2CSpawnParticle.class, id++).encoder(MessageC2S2CSpawnParticle::serialize).decoder(MessageC2S2CSpawnParticle::deserialize).consumer(MessageC2S2CSpawnParticle::handle).add();
    }
}

