/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.repack.registrate.builders;

import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.AbstractBuilder;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.ProviderType;
import com.simibubi.create.repack.registrate.util.entry.RegistryEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidBuilder<T extends ForgeFlowingFluid, P>
extends AbstractBuilder<Fluid, T, P, FluidBuilder<T, P>> {
    private final ResourceLocation stillTexture;
    private final String sourceName;
    private final String bucketName;
    private final NonNullSupplier<FluidAttributes.Builder> attributes;
    private final NonNullFunction<ForgeFlowingFluid.Properties, T> factory;
    private NonNullConsumer<FluidAttributes.Builder> attributesCallback = $ -> {};
    private NonNullConsumer<ForgeFlowingFluid.Properties> properties;
    @Nullable
    private NonNullSupplier<? extends ForgeFlowingFluid> source;

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, (NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes>)null);
    }

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, attributesFactory, ForgeFlowingFluid.Flowing::new);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, null, factory);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        FluidBuilder<T, P> ret = new FluidBuilder<T, P>(owner, parent, name, callback, stillTexture, flowingTexture, attributesFactory, factory).defaultSource().defaultBlock().defaultBucket().tag((Tag<Fluid>)FluidTags.field_206959_a);
        return ret;
    }

    protected FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        super(owner, parent, "flowing_" + name, callback, Fluid.class);
        this.stillTexture = stillTexture;
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.attributes = () -> attributesFactory == null ? FluidAttributes.builder((ResourceLocation)stillTexture, (ResourceLocation)flowingTexture) : new Builder(stillTexture, flowingTexture, attributesFactory);
        this.factory = factory;
        this.properties = p -> p.bucket(() -> (Item)this.getOwner().get(this.bucketName, Item.class).get()).block(() -> (FlowingFluidBlock)this.getOwner().get(name, Block.class).get());
    }

    public FluidBuilder<T, P> attributes(NonNullConsumer<FluidAttributes.Builder> cons) {
        this.attributesCallback = this.attributesCallback.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> properties(NonNullConsumer<ForgeFlowingFluid.Properties> cons) {
        this.properties = this.properties.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> defaultSource() {
        return this.source(ForgeFlowingFluid.Source::new);
    }

    public FluidBuilder<T, P> source(NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid> factory) {
        this.source = () -> (ForgeFlowingFluid)factory.apply(this.makeProperties());
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        return (FluidBuilder)this.block().build();
    }

    public BlockBuilder<FlowingFluidBlock, FluidBuilder<T, P>> block() {
        return this.block(FlowingFluidBlock::new);
    }

    public <B extends FlowingFluidBlock> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, Block.Properties, ? extends B> factory) {
        return this.getOwner().block(this, this.sourceName, p -> (FlowingFluidBlock)factory.apply(this, (Block.Properties)p)).properties(p -> Block.Properties.func_200950_a((Block)Blocks.field_150355_j).func_222380_e()).properties(p -> {
            FluidAttributes attrs = this.attributes.get().build((Fluid)Fluids.field_204546_a);
            return p.func_200951_a(attrs.getLuminosity());
        }).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture)));
    }

    public FluidBuilder<T, P> defaultBucket() {
        return (FluidBuilder)this.bucket().build();
    }

    public ItemBuilder<BucketItem, FluidBuilder<T, P>> bucket() {
        return this.bucket(BucketItem::new);
    }

    public <I extends BucketItem> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<Supplier<? extends ForgeFlowingFluid>, Item.Properties, ? extends I> factory) {
        return this.getOwner().item(this, this.bucketName, p -> (BucketItem)factory.apply((Supplier<? extends ForgeFlowingFluid>)this.getSource(), (Item.Properties)p)).model((ctx, prov) -> prov.generated(ctx::getEntry, new ResourceLocation(this.getOwner().getModid(), "item/" + this.bucketName)));
    }

    public FluidBuilder<T, P> tag(Tag<Fluid> tag) {
        FluidBuilder ret = (FluidBuilder)this.tag(ProviderType.FLUID_TAGS, tag);
        ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryType(), ProviderType.FLUID_TAGS, prov -> prov.func_200426_a(FluidTags.field_206959_a).func_200048_a((Object)ret.getSource().get()));
        return ret;
    }

    private Supplier<ForgeFlowingFluid.Source> getSource() {
        return () -> ((LazyValue)new LazyValue(() -> (ForgeFlowingFluid.Source)this.getOwner().get(this.sourceName, Fluid.class).get())).func_179281_c();
    }

    private ForgeFlowingFluid.Properties makeProperties() {
        FluidAttributes.Builder attributes = this.attributes.get();
        this.attributesCallback.accept(attributes);
        ForgeFlowingFluid.Properties ret = new ForgeFlowingFluid.Properties(this.getSource(), (Supplier)this, attributes);
        this.properties.accept(ret);
        return ret;
    }

    @Override
    protected T createEntry() {
        return (T)((ForgeFlowingFluid)this.factory.apply(this.makeProperties()));
    }

    @Override
    public RegistryEntry<T> register() {
        NonNullSupplier<? extends ForgeFlowingFluid> source = this.source;
        if (source != null) {
            this.getCallback().accept(this.sourceName, Fluid.class, this, source);
        }
        return super.register();
    }

    private static class Builder
    extends FluidAttributes.Builder {
        protected Builder(ResourceLocation still, ResourceLocation flowing, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
            super(still, flowing, attributesFactory);
        }
    }
}

