/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.IBehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.ExtractingBehaviour;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class AutoExtractingBehaviour
extends ExtractingBehaviour {
    public static IBehaviourType<AutoExtractingBehaviour> TYPE = new IBehaviourType<AutoExtractingBehaviour>(){};
    private int delay;
    private int timer;
    Supplier<Boolean> shouldExtract;
    Supplier<Boolean> shouldPause = () -> false;
    private boolean ticking = true;

    public AutoExtractingBehaviour(SmartTileEntity te, Supplier<List<Pair<BlockPos, Direction>>> attachments, Consumer<ItemStack> onExtract, int delay) {
        super(te, attachments, onExtract);
        this.shouldExtract = () -> true;
        this.delay = delay;
    }

    public AutoExtractingBehaviour pauseWhen(Supplier<Boolean> condition) {
        this.shouldPause = condition;
        return this;
    }

    public ExtractingBehaviour waitUntil(Supplier<Boolean> condition) {
        this.shouldExtract = condition;
        return this;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
    }

    @Override
    public boolean extract(int amount) {
        this.timer = this.delay;
        return super.extract(amount);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.ticking) {
            return;
        }
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getShouldPause().get().booleanValue()) {
            this.timer = 0;
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        if (!this.getShouldExtract().get().booleanValue()) {
            return;
        }
        this.extract();
    }

    public void setTicking(boolean ticking) {
        this.ticking = ticking;
    }

    @Override
    public IBehaviourType<?> getType() {
        return TYPE;
    }

    public Supplier<Boolean> getShouldExtract() {
        return this.shouldExtract;
    }

    public Supplier<Boolean> getShouldPause() {
        return this.shouldPause;
    }
}

