/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.curiosities.tools.AllToolTiers;
import com.simibubi.create.content.curiosities.tools.SandPaperItem;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.WipScription;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.text.TextFormatting;

public class TooltipHelper {
    public static final int maxCharsPerLine = 35;
    public static final Map<String, ItemDescription> cachedTooltips = new HashMap<String, ItemDescription>();
    public static com.mojang.bridge.game.Language cachedLanguage;
    private static boolean gogglesMode;

    public static String holdShift(ItemDescription.Palette color, boolean highlighted) {
        TextFormatting colorFormat = highlighted ? color.hColor : color.color;
        return TextFormatting.DARK_GRAY + Lang.translate("tooltip.holdKey", colorFormat + Lang.translate("tooltip.keyShift", new Object[0]) + TextFormatting.DARK_GRAY);
    }

    public static List<String> cutString(String s, TextFormatting defaultColor, TextFormatting highlightColor) {
        return TooltipHelper.cutString(s, defaultColor, highlightColor, 0);
    }

    public static List<String> cutString(String s, TextFormatting defaultColor, TextFormatting highlightColor, int indent) {
        String lineStart = defaultColor.toString();
        for (int i = 0; i < indent; ++i) {
            lineStart = lineStart + " ";
        }
        String markedUp = s.replaceAll("_([^_]+)_", highlightColor + "$1" + defaultColor);
        String[] words = markedUp.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder(lineStart);
        boolean firstWord = true;
        for (int i = 0; i < words.length; ++i) {
            boolean lastWord;
            String word = words[i];
            boolean bl = lastWord = i == words.length - 1;
            if (!lastWord && !firstWord && currentLine.length() + word.length() > 35) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(lineStart);
                firstWord = true;
            }
            currentLine.append((firstWord ? "" : " ") + word);
            firstWord = false;
        }
        if (!firstWord) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static void checkLocale() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (cachedLanguage != currentLanguage) {
            cachedTooltips.clear();
            cachedLanguage = currentLanguage;
        }
    }

    public static boolean hasTooltip(ItemStack stack) {
        String key;
        boolean hasGlasses;
        TooltipHelper.checkLocale();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean bl = hasGlasses = player != null && AllItems.GOGGLES.isIn(player.func_184582_a(EquipmentSlotType.HEAD));
        if (hasGlasses != gogglesMode) {
            gogglesMode = hasGlasses;
            cachedTooltips.clear();
        }
        if (cachedTooltips.containsKey(key = TooltipHelper.getTooltipTranslationKey(stack))) {
            return cachedTooltips.get(key) != ItemDescription.MISSING;
        }
        return TooltipHelper.findTooltip(stack);
    }

    public static ItemDescription getTooltip(ItemStack stack) {
        ItemDescription itemDescription;
        TooltipHelper.checkLocale();
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (cachedTooltips.containsKey(key) && (itemDescription = cachedTooltips.get(key)) != ItemDescription.MISSING) {
            return itemDescription;
        }
        return null;
    }

    private static boolean findTooltip(ItemStack stack) {
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (I18n.func_188566_a((String)key)) {
            cachedTooltips.put(key, TooltipHelper.buildToolTip(key, stack));
            return true;
        }
        cachedTooltips.put(key, ItemDescription.MISSING);
        return false;
    }

    private static ItemDescription buildToolTip(String translationKey, ItemStack stack) {
        int i;
        BlockItem item;
        AllSections module = AllSections.of(stack);
        if (I18n.func_135052_a((String)translationKey, (Object[])new Object[0]).equals("WIP")) {
            return new WipScription(module.getTooltipPalette());
        }
        ItemDescription tooltip = new ItemDescription(module.getTooltipPalette());
        String summaryKey = translationKey + ".summary";
        if (I18n.func_188566_a((String)summaryKey)) {
            tooltip = tooltip.withSummary(I18n.func_135052_a((String)summaryKey, (Object[])new Object[0]));
        }
        if (stack.func_77973_b() instanceof BlockItem && ((item = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof IRotate || item.func_179223_d() instanceof EngineBlock)) {
            tooltip = tooltip.withKineticStats(item.func_179223_d());
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.func_188566_a((String)conditionKey)) break;
            tooltip.withBehaviour(I18n.func_135052_a((String)conditionKey, (Object[])new Object[0]), I18n.func_135052_a((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.func_188566_a((String)controlKey)) break;
            tooltip.withControl(I18n.func_135052_a((String)controlKey, (Object[])new Object[0]), I18n.func_135052_a((String)actionKey, (Object[])new Object[0]));
        }
        return tooltip.createTabs();
    }

    public static String getTooltipTranslationKey(ItemStack stack) {
        TieredItem tieredItem;
        Item item = stack.func_77973_b();
        if (item instanceof TieredItem && (tieredItem = (TieredItem)stack.func_77973_b()).func_200891_e() instanceof AllToolTiers) {
            AllToolTiers allToolTiers = (AllToolTiers)tieredItem.func_200891_e();
            return "tool.create." + Lang.asId(allToolTiers.name()) + ".tooltip";
        }
        if (stack.func_77973_b() instanceof SandPaperItem) {
            return "tool.create.sand_paper.tooltip";
        }
        return stack.func_77973_b().func_77667_c(stack) + ".tooltip";
    }
}

