/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.content.schematics.packet.ConfigureSchematicannonPacket;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonContainer> {
    protected Vector<Indicator> replaceLevelIndicators;
    protected Vector<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipTilesButton;
    protected Indicator skipTilesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private List<Rectangle2d> extraAreas;
    private final String title = Lang.translate("gui.schematicannon.title", new Object[0]);
    private final String settingsTitle = Lang.translate("gui.schematicannon.settingsTitle", new Object[0]);
    private final String listPrinter = Lang.translate("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String optionEnabled = Lang.translate("gui.schematicannon.optionEnabled", new Object[0]);
    private final String optionDisabled = Lang.translate("gui.schematicannon.optionDisabled", new Object[0]);

    public SchematicannonScreen(SchematicannonContainer container, PlayerInventory inventory, ITextComponent p_i51105_3_) {
        super(container, inventory, p_i51105_3_);
    }

    protected void init() {
        this.setWindowSize(AllGuiTextures.SCHEMATICANNON_BG.width + 50, AllGuiTextures.SCHEMATICANNON_BG.height + 80);
        super.init();
        int x = this.field_147003_i + 20;
        int y = this.field_147009_r;
        this.widgets.clear();
        this.playButton = new IconButton(x + 70, y + 55, AllIcons.I_PLAY);
        this.playIndicator = new Indicator(x + 70, y + 50, "");
        this.pauseButton = new IconButton(x + 88, y + 55, AllIcons.I_PAUSE);
        this.pauseIndicator = new Indicator(x + 88, y + 50, "");
        this.resetButton = new IconButton(x + 106, y + 55, AllIcons.I_STOP);
        this.resetIndicator = new Indicator(x + 106, y + 50, "");
        this.resetIndicator.state = Indicator.State.RED;
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.replaceLevelButtons = new Vector(4);
        this.replaceLevelIndicators = new Vector(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)Lang.translate("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(x + 16 + i * 18, y + 96, ""));
            this.replaceLevelButtons.add(new IconButton(x + 16 + i * 18, y + 101, (AllIcons)icons.get(i)));
            this.replaceLevelButtons.get(i).setToolTip((String)toolTips.get(i));
        }
        this.widgets.addAll(this.replaceLevelButtons);
        this.widgets.addAll(this.replaceLevelIndicators);
        this.skipMissingButton = new IconButton(x + 106, y + 101, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.setToolTip(Lang.translate("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(x + 106, y + 96, "");
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{this.skipMissingButton, this.skipMissingIndicator});
        this.skipTilesButton = new IconButton(x + 124, y + 101, AllIcons.I_SKIP_TILES);
        this.skipTilesButton.setToolTip(Lang.translate("gui.schematicannon.option.skipTileEntities", new Object[0]));
        this.skipTilesIndicator = new Indicator(x + 124, y + 96, "");
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{this.skipTilesButton, this.skipTilesIndicator});
        this.extraAreas = new ArrayList<Rectangle2d>();
        this.extraAreas.add(new Rectangle2d(this.field_147003_i + 240, this.field_147009_r + 88, 84, 113));
        this.tick();
    }

    public void tick() {
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        this.replaceLevelIndicators.get((int)0).state = te.replaceMode == 0 ? Indicator.State.ON : Indicator.State.OFF;
        for (int replaceMode = 1; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
            this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode <= te.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
        }
        this.skipMissingIndicator.state = te.skipMissing ? Indicator.State.ON : Indicator.State.OFF;
        this.skipTilesIndicator.state = !te.replaceTileEntities ? Indicator.State.ON : Indicator.State.OFF;
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (te.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.active = true;
                this.pauseButton.active = false;
                this.resetButton.active = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.active = false;
                this.pauseButton.active = true;
                this.resetButton.active = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.active = true;
                this.pauseButton.active = false;
                this.resetButton.active = false;
                break;
            }
        }
        this.handleTooltips();
        super.tick();
    }

    protected void handleTooltips() {
        for (Widget w : this.widgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add(TooltipHelper.holdShift(ItemDescription.Palette.Blue, SchematicannonScreen.hasShiftDown()));
        }
        if (SchematicannonScreen.hasShiftDown()) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipTilesButton, this.skipTilesIndicator, "skipTileEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.isHovered()) {
            return;
        }
        boolean enabled = indicator.state == Indicator.State.ON;
        List<String> tip = button.getToolTip();
        tip.add(TextFormatting.BLUE + (enabled ? this.optionEnabled : this.optionDisabled));
        tip.addAll(TooltipHelper.cutString(Lang.translate("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), TextFormatting.GRAY, TextFormatting.GRAY));
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.PLAYER_INVENTORY.draw((AbstractGui)this, this.field_147003_i - 10, this.field_147009_r + 145);
        AllGuiTextures.SCHEMATICANNON_BG.draw((AbstractGui)this, this.field_147003_i + 20, this.field_147009_r);
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        this.renderPrintingProgress(te.schematicProgress);
        this.renderFuelBar(te.fuelLevel);
        this.renderChecklistPrinterProgress(te.bookPrintingProgress);
        if (!te.inventory.getStackInSlot(0).func_190926_b()) {
            this.renderBlueprintHighlight();
        }
        this.renderCannon();
        this.font.func_211126_b(this.title, (float)(this.field_147003_i + 80), (float)(this.field_147009_r + 10), 5726074);
        String msg = Lang.translate("schematicannon.status." + te.statusMsg, new Object[0]);
        int stringWidth = this.font.func_78256_a(msg);
        if (te.missingItem != null) {
            stringWidth += 15;
            this.itemRenderer.func_175042_a(te.missingItem, this.field_147003_i + 145, this.field_147009_r + 25);
        }
        this.font.func_175063_a(msg, (float)(this.field_147003_i + 20 + 96 - stringWidth / 2), (float)(this.field_147009_r + 30), 0xCCDDFF);
        this.font.func_211126_b(this.settingsTitle, (float)(this.field_147003_i + 20 + 13), (float)(this.field_147009_r + 84), 5726074);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), (float)(this.field_147003_i - 10 + 7), (float)(this.field_147009_r + 145 + 6), 0x666666);
    }

    protected void renderCannon() {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderHelper.func_227784_d_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translated((double)(this.field_147003_i + 240), (double)(this.field_147009_r + 120), (double)200.0);
        RenderSystem.scaled((double)5.0, (double)5.0, (double)5.0);
        this.itemRenderer.func_175042_a(new ItemStack((IItemProvider)AllBlocks.SCHEMATICANNON.get()), 0, 0);
        RenderSystem.popMatrix();
    }

    protected void renderBlueprintHighlight() {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.draw((AbstractGui)this, this.field_147003_i + 20 + 8, this.field_147009_r + 31);
    }

    protected void renderPrintingProgress(float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        this.minecraft.func_110434_K().func_110577_a(sprite.location);
        this.blit(this.field_147003_i + 20 + 39, this.field_147009_r + 36, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderChecklistPrinterProgress(float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS_2;
        this.minecraft.func_110434_K().func_110577_a(sprite.location);
        this.blit(this.field_147003_i + 20 + 222, this.field_147009_r + 42, sprite.startX, sprite.startY, sprite.width, (int)((float)sprite.height * progress));
    }

    protected void renderFuelBar(float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonContainer)this.field_147002_h).getTileEntity().hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.draw((AbstractGui)this, this.field_147003_i + 20 + 73, this.field_147009_r + 135);
            return;
        }
        this.minecraft.func_110434_K().func_110577_a(sprite.location);
        this.blit(this.field_147003_i + 20 + 73, this.field_147009_r + 135, sprite.startX, sprite.startY, (int)((float)sprite.width * amount), sprite.height);
    }

    @Override
    protected void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        int fuelX = this.field_147003_i + 20 + 73;
        int fuelY = this.field_147009_r + 135;
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.width && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.height) {
            ((SchematicannonContainer)this.field_147002_h).getTileEntity();
            double fuelUsageRate = te.getFuelUsageRate();
            int shotsLeft = (int)((double)te.fuelLevel / fuelUsageRate);
            int shotsLeftWithItems = (int)((double)shotsLeft + (double)te.inventory.getStackInSlot(4).func_190916_E() * (te.getFuelAddedByGunPowder() / fuelUsageRate));
            ArrayList<String> tooltip = new ArrayList<String>();
            float f = te.hasCreativeCrate ? 100.0f : te.fuelLevel * 100.0f;
            tooltip.add(Lang.translate("gui.schematicannon.gunpowderLevel", "" + (int)f));
            if (!te.hasCreativeCrate) {
                tooltip.add(TextFormatting.GRAY + Lang.translate("gui.schematicannon.shotsRemaining", "" + TextFormatting.BLUE + shotsLeft));
            }
            if (shotsLeftWithItems != shotsLeft) {
                tooltip.add(TextFormatting.GRAY + Lang.translate("gui.schematicannon.shotsRemainingWithBackup", "" + TextFormatting.BLUE + shotsLeftWithItems));
            }
            this.renderTooltip(tooltip, mouseX, mouseY);
        }
        if (te.missingItem != null) {
            int missingBlockX = this.field_147003_i + 145;
            int missingBlockY = this.field_147009_r + 25;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                this.renderTooltip(te.missingItem, mouseX, mouseY);
            }
        }
        int paperX = this.field_147003_i + 20 + 202;
        int paperY = this.field_147009_r + 20;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            this.renderTooltip(this.listPrinter, mouseX, mouseY);
        }
        super.renderWindowForeground(mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
            if (!this.replaceLevelButtons.get(replaceMode).isHovered() || ((SchematicannonContainer)this.field_147002_h).getTileEntity().replaceMode == replaceMode) continue;
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
        }
        if (this.skipMissingButton.isHovered()) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonContainer)this.field_147002_h).getTileEntity().skipMissing);
        }
        if (this.skipTilesButton.isHovered()) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_TILES, !((SchematicannonContainer)this.field_147002_h).getTileEntity().replaceTileEntities);
        }
        if (this.playButton.isHovered() && this.playButton.active) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true);
        }
        if (this.pauseButton.isHovered() && this.pauseButton.active) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true);
        }
        if (this.resetButton.isHovered() && this.resetButton.active) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true);
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        AllPackets.channel.sendToServer((Object)ConfigureSchematicannonPacket.setOption(((SchematicannonContainer)this.field_147002_h).getTileEntity().func_174877_v(), option, set));
    }
}

