/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts;

import com.simibubi.create.content.contraptions.relays.belt.AllBeltAttachments;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.SingleTargetAutoExtractingBehaviour;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class BeltAttachableLogisticalBlock
extends AttachedLogisticalBlock
implements AllBeltAttachments.IBeltAttachment {
    public BeltAttachableLogisticalBlock(Block.Properties properties) {
        super(properties);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.onAttachmentPlaced((IWorld)worldIn, pos, state);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onAttachmentRemoved((IWorld)worldIn, pos, state);
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            TileEntityBehaviour.destroy((ILightReader)worldIn, pos, FilteringBehaviour.TYPE);
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public BlockPos getBeltPositionForAttachment(IWorld world, BlockPos pos, BlockState state) {
        return pos.func_177972_a(BeltAttachableLogisticalBlock.getBlockFacing(state));
    }

    @Override
    public List<BlockPos> getPotentialAttachmentPositions(IWorld world, BlockPos pos, BlockState beltState) {
        return Arrays.asList(Direction.values()).stream().filter(d -> d != Direction.UP).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).collect(Collectors.toList());
    }

    @Override
    public boolean startProcessingItem(BeltTileEntity te, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        BlockPos pos = state.attachmentPos;
        World world = te.func_145831_w();
        ItemStack stack = transported.stack;
        FilteringBehaviour filtering = TileEntityBehaviour.get((ILightReader)world, pos, FilteringBehaviour.TYPE);
        SingleTargetAutoExtractingBehaviour extracting = TileEntityBehaviour.get((ILightReader)world, pos, SingleTargetAutoExtractingBehaviour.TYPE);
        if (extracting == null) {
            return false;
        }
        return filtering == null || filtering.test(stack) && stack.func_190916_E() >= filtering.getAmount();
    }

    @Override
    public boolean processItem(BeltTileEntity te, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        BlockPos pos = state.attachmentPos;
        World world = te.func_145831_w();
        ItemStack stack = transported.stack;
        SingleTargetAutoExtractingBehaviour extracting = TileEntityBehaviour.get((ILightReader)world, pos, SingleTargetAutoExtractingBehaviour.TYPE);
        if (extracting == null) {
            return false;
        }
        if (extracting.getShouldPause().get().booleanValue()) {
            return false;
        }
        FilteringBehaviour filtering = TileEntityBehaviour.get((ILightReader)world, pos, FilteringBehaviour.TYPE);
        if (!(filtering == null || filtering.test(stack) && stack.func_190916_E() >= filtering.getAmount())) {
            return false;
        }
        if (!extracting.getShouldExtract().get().booleanValue()) {
            return true;
        }
        return !extracting.extractFromInventory();
    }
}

