/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.ShadowRenderHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;

public class BeltRenderer
extends SafeTileEntityRenderer<BeltTileEntity> {
    public BeltRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(BeltTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState blockState = te.func_195044_w();
        if (!AllBlocks.BELT.has(blockState)) {
            return;
        }
        BlockState renderedState = this.getBeltState(te);
        SuperByteBuffer beltBuffer = CreateClient.bufferCache.renderBlockIn(KineticTileEntityRenderer.KINETIC_TILE, renderedState);
        beltBuffer.color(te.color == -1 ? 0x808080 : te.color);
        float speed = te.getSpeed();
        if (speed != 0.0f) {
            int textureIndex;
            float time = AnimationTickHolder.getRenderTick() * (float)((Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176743_c().func_179524_a();
            if (((Direction)renderedState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() == Direction.Axis.X) {
                speed = -speed;
            }
            if ((textureIndex = (int)(speed * time / 36.0f % 16.0f)) < 0) {
                textureIndex += 16;
            }
            beltBuffer.shiftUVtoSheet(AllSpriteShifts.BELT, (float)(textureIndex % 4) / 4.0f, (float)(textureIndex / 4) / 4.0f, 4);
        } else {
            beltBuffer.dontShiftUV();
        }
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        int packedLightmapCoords = WorldRenderer.func_228420_a_((ILightReader)te.func_145831_w(), (BlockState)blockState, (BlockPos)te.func_174877_v());
        beltBuffer.light(packedLightmapCoords).renderInto(ms, vb);
        if (te.hasPulley()) {
            MatrixStack modelTransform = new MatrixStack();
            Direction dir = (Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING);
            modelTransform.func_227861_a_(0.5, 0.5, 0.5);
            modelTransform.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(dir.func_176740_k() == Direction.Axis.X ? 0.0 : 1.5707963267948966)));
            modelTransform.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(1.5707964f));
            modelTransform.func_227861_a_(-0.5, -0.5, -0.5);
            SuperByteBuffer superBuffer = CreateClient.bufferCache.renderDirectionalPartial(AllBlockPartials.BELT_PULLEY, blockState, dir, modelTransform);
            KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, vb);
        }
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItems(BeltTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (!te.isController()) {
            return;
        }
        if (te.beltLength == 0) {
            return;
        }
        ms.func_227860_a_();
        Vec3i directionVec = te.getBeltFacing().func_176730_m();
        Vec3d beltStartOffset = new Vec3d(directionVec).func_186678_a(-0.5).func_72441_c(0.5, 0.9375, 0.5);
        ms.func_227861_a_(beltStartOffset.field_72450_a, beltStartOffset.field_72448_b, beltStartOffset.field_72449_c);
        BeltBlock.Slope slope = (BeltBlock.Slope)((Object)te.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltBlock.Slope.DOWNWARD ? -1 : (slope == BeltBlock.Slope.UPWARD ? 1 : 0);
        boolean slopeAlongX = te.getBeltFacing().func_176740_k() == Direction.Axis.X;
        for (TransportedItemStack transported : te.getInventory().getItems()) {
            boolean alongX;
            boolean tiltForward;
            ms.func_227860_a_();
            MatrixStacker.of(ms).nudge(transported.angle);
            float offset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
            float sideOffset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            float verticalMovement = verticality;
            if (te.getSpeed() == 0.0f) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            }
            if ((double)offset < 0.5) {
                verticalMovement = 0.0f;
            }
            Vec3d offsetVec = new Vec3d(directionVec).func_186678_a((double)offset).func_72441_c(0.0, (double)(verticalMovement *= Math.min(offset, (float)te.beltLength - 0.5f) - 0.5f), 0.0);
            boolean onSlope = slope != BeltBlock.Slope.HORIZONTAL && MathHelper.func_76131_a((float)offset, (float)0.5f, (float)((float)te.beltLength - 0.5f)) == offset;
            boolean bl = tiltForward = (slope == BeltBlock.Slope.DOWNWARD ^ te.getBeltFacing().func_176743_c() == Direction.AxisDirection.POSITIVE) == (te.getBeltFacing().func_176740_k() == Direction.Axis.Z);
            float slopeAngle = onSlope ? (tiltForward ? -45.0f : 45.0f) : 0.0f;
            ms.func_227861_a_(offsetVec.field_72450_a, offsetVec.field_72448_b, offsetVec.field_72449_c);
            boolean bl2 = alongX = te.getBeltFacing().func_176746_e().func_176740_k() == Direction.Axis.X;
            if (!alongX) {
                sideOffset *= -1.0f;
            }
            ms.func_227861_a_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            boolean blockItem = itemRenderer.func_184393_a(transported.stack, te.func_145831_w(), null).func_177556_c();
            if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                Vec3d shadowPos = new Vec3d((Vec3i)te.func_174877_v()).func_178787_e(beltStartOffset.func_186678_a(1.0).func_178787_e(offsetVec).func_72441_c(alongX ? (double)sideOffset : 0.0, 0.39, alongX ? 0.0 : (double)sideOffset));
                ShadowRenderHelper.renderShadow(ms, buffer, shadowPos, 0.75f, blockItem ? 0.2f : 0.2f);
            }
            int count = MathHelper.func_151239_c((int)transported.stack.func_190916_E()) / 2;
            ms.func_227863_a_(new Vector3f(slopeAlongX ? 0.0f : 1.0f, 0.0f, slopeAlongX ? 1.0f : 0.0f).func_229187_a_(slopeAngle));
            if (onSlope) {
                ms.func_227861_a_(0.0, 0.125, 0.0);
            }
            Random r = new Random(transported.angle);
            for (int i = 0; i <= count; ++i) {
                ms.func_227860_a_();
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)transported.angle));
                if (!blockItem) {
                    ms.func_227861_a_(0.0, -0.09375, 0.0);
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                }
                if (blockItem) {
                    ms.func_227861_a_((double)(r.nextFloat() * 0.0625f * (float)i), 0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
                }
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
                itemRenderer.func_229110_a_(transported.stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
                ms.func_227865_b_();
                if (!blockItem) {
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(10.0f));
                }
                ms.func_227861_a_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
            }
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    protected BlockState getBeltState(KineticTileEntity te) {
        return (BlockState)te.func_195044_w().func_206870_a((IProperty)BeltBlock.CASING, (Comparable)Boolean.valueOf(false));
    }
}

