/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CartAssemblerBlock
extends AbstractRailBlock
implements ITE<CartAssemblerTileEntity>,
IWrenchable {
    public static IProperty<RailShape> RAIL_SHAPE = EnumProperty.func_177706_a((String)"shape", RailShape.class, (Enum[])new RailShape[]{RailShape.EAST_WEST, RailShape.NORTH_SOUTH});
    public static BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public CartAssemblerBlock(Block.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{RAIL_SHAPE, POWERED});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CART_ASSEMBLER.create();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean alongX = context.func_195992_f().func_176740_k() == Direction.Axis.X;
        boolean powered = context.func_195991_k().func_175640_z(context.func_195995_a());
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered))).func_206870_a(RAIL_SHAPE, (Comparable)(alongX ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH));
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (!cart.canBeRidden() && !(cart instanceof FurnaceMinecartEntity)) {
            return;
        }
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            if (te.isMinecartUpdateValid()) {
                if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                    this.assemble(world, pos, cart);
                    Direction facing = cart.func_184172_bi();
                    cart.func_70016_h((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
                } else {
                    this.disassemble(world, pos, cart);
                    Vec3d diff = VecHelper.getCenterOf((Vec3i)pos).func_178788_d(cart.func_213303_ch());
                    cart.func_70016_h(diff.field_72450_a / 16.0, 0.0, diff.field_72449_c / 16.0);
                }
                te.resetTicksSinceMinecartUpdate();
            }
        });
    }

    protected void assemble(World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (!cart.func_184188_bt().isEmpty()) {
            return;
        }
        MountedContraption contraption = MountedContraption.assembleMinecart(world, pos);
        if (contraption == null) {
            return;
        }
        if (contraption.blocks.size() == 1) {
            return;
        }
        Direction facing = cart.func_184172_bi();
        float initialAngle = facing.func_185119_l();
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            contraption.rotationMode = CartAssemblerTileEntity.CartMovementMode.values()[te.movementMode.value];
        });
        ContraptionEntity entity = ContraptionEntity.createMounted(world, contraption, initialAngle, facing);
        entity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        world.func_217376_c((Entity)entity);
        entity.func_184220_m((Entity)cart);
        if (cart instanceof FurnaceMinecartEntity) {
            CompoundNBT nbt = cart.serializeNBT();
            nbt.func_74780_a("PushZ", 0.0);
            nbt.func_74780_a("PushX", 0.0);
            cart.deserializeNBT(nbt);
        }
    }

    protected void disassemble(World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (cart.func_184188_bt().isEmpty()) {
            return;
        }
        if (!(cart.func_184188_bt().get(0) instanceof ContraptionEntity)) {
            return;
        }
        cart.func_184226_ay();
        if (cart instanceof FurnaceMinecartEntity) {
            CompoundNBT nbt = cart.serializeNBT();
            nbt.func_74780_a("PushZ", cart.func_213322_ci().field_72450_a);
            nbt.func_74780_a("PushX", cart.func_213322_ci().field_72449_c);
            cart.deserializeNBT(nbt);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn.field_72995_K) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    public IProperty<RailShape> func_176560_l() {
        return RAIL_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.CART_ASSEMBLER.get(state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof AbstractMinecartEntity) {
            return VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197868_b();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public static BlockState createAnchor(BlockState state) {
        Direction.Axis axis = state.func_177229_b(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)AllBlocks.MINECART_ANCHOR.getDefaultState().func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)axis);
    }

    @Override
    public Class<CartAssemblerTileEntity> getTileEntityClass() {
        return CartAssemblerTileEntity.class;
    }

    public static class MinecartAnchorBlock
    extends Block {
        public MinecartAnchorBlock(Block.Properties p_i48440_1_) {
            super(p_i48440_1_);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208199_z});
            super.func_206840_a(builder);
        }

        public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
            return VoxelShapes.func_197880_a();
        }
    }
}

