/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.DirectionalExtenderScrollOptionSlot;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingBlock;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;

public class MechanicalBearingTileEntity
extends GeneratingKineticTileEntity
implements IBearingTileEntity {
    protected boolean isWindmill = false;
    protected ContraptionEntity movedContraption;
    protected float angle;
    protected boolean running;
    protected boolean assembleNextTick;
    protected float clientAngleDiff;
    protected ScrollOptionBehaviour<IControlContraption.RotationMode> movementMode;
    protected float lastGeneratedSpeed;

    public MechanicalBearingTileEntity(TileEntityType<? extends MechanicalBearingTileEntity> type) {
        super(type);
        this.setLazyTickRate(3);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour<IControlContraption.RotationMode>(IControlContraption.RotationMode.class, Lang.translate("contraptions.movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        behaviours.add(this.movementMode);
    }

    @Override
    public float calculateAddedStressCapacity() {
        return this.isWindmill ? super.calculateAddedStressCapacity() : 0.0f;
    }

    @Override
    public float calculateStressApplied() {
        return this.isWindmill ? 0.0f : super.calculateStressApplied();
    }

    public void neighbourChanged() {
        if (!this.func_145830_o()) {
            return;
        }
        boolean shouldWindmill = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (shouldWindmill == this.isWindmill) {
            return;
        }
        this.isWindmill = shouldWindmill;
        if (this.isWindmill && !this.running) {
            this.assembleNextTick = true;
        }
        if (this.isWindmill && this.running) {
            this.updateGeneratedRotation();
        }
        if (!this.isWindmill && this.running) {
            this.updateGeneratedRotation();
            if (this.getSpeed() == 0.0f) {
                this.assembleNextTick = true;
            }
        }
        this.sendData();
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.disassemble();
        }
        super.func_145843_s();
    }

    @Override
    public float getGeneratedSpeed() {
        if (!this.running || !this.isWindmill) {
            return 0.0f;
        }
        if (this.movedContraption == null) {
            return this.lastGeneratedSpeed;
        }
        int sails = ((BearingContraption)this.movedContraption.getContraption()).getSailBlocks() / 8;
        return MathHelper.func_76125_a((int)sails, (int)1, (int)16);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("Running", this.running);
        tag.func_74757_a("Windmill", this.isWindmill);
        tag.func_74776_a("Angle", this.angle);
        tag.func_74776_a("LastGenerated", this.lastGeneratedSpeed);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.running = tag.func_74767_n("Running");
        this.isWindmill = tag.func_74767_n("Windmill");
        this.angle = tag.func_74760_g("Angle");
        this.lastGeneratedSpeed = tag.func_74760_g("LastGenerated");
        super.func_145839_a(tag);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        float angleBefore = this.angle;
        super.readClientUpdate(tag);
        if (this.running) {
            this.clientAngleDiff = AngleHelper.getShortestAngleDiff(angleBefore, this.angle);
            this.angle = angleBefore;
        } else {
            this.movedContraption = null;
        }
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        return MathHelper.func_219799_g((float)partialTicks, (float)this.angle, (float)(this.angle + this.getAngularSpeed()));
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    public float getAngularSpeed() {
        float speed = this.getSpeed() * 3.0f / 10.0f;
        if (this.field_145850_b.field_72995_K) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    public void assemble() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof MechanicalBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BearingContraption contraption = BearingContraption.assembleBearingAt(this.field_145850_b, this.field_174879_c, direction);
        if (contraption == null) {
            return;
        }
        if (this.isWindmill && contraption.getSailBlocks() == 0) {
            return;
        }
        if (contraption.blocks.isEmpty()) {
            return;
        }
        contraption.removeBlocksFromWorld((IWorld)this.field_145850_b, BlockPos.field_177992_a);
        this.movedContraption = ContraptionEntity.createStationary(this.field_145850_b, contraption).controlledBy(this);
        BlockPos anchor = this.field_174879_c.func_177972_a(direction);
        this.movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        this.field_145850_b.func_217376_c((Entity)this.movedContraption);
        this.running = true;
        this.angle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    @Override
    public void updateGeneratedRotation() {
        super.updateGeneratedRotation();
        this.lastGeneratedSpeed = this.getGeneratedSpeed();
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
        }
        this.movedContraption = null;
        this.running = false;
        this.angle = 0.0f;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.clientAngleDiff /= 2.0f;
        }
        if (this.running && Contraption.isFrozen()) {
            this.disassemble();
        }
        if (!this.field_145850_b.field_72995_K && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble;
                boolean bl = canDisassemble = this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE || this.isNearInitialAngle() && this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE_RETURNED;
                if (this.speed == 0.0f && (canDisassemble || this.movedContraption == null || this.movedContraption.getContraption().blocks.isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.field_145850_b);
                    }
                    this.disassemble();
                }
                return;
            }
            if (this.speed == 0.0f && !this.isWindmill) {
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.isStalled()) {
            float angularSpeed = this.getAngularSpeed();
            float newAngle = this.angle + angularSpeed;
            this.angle = newAngle % 360.0f;
        }
        this.applyRotation();
    }

    public boolean isNearInitialAngle() {
        return Math.abs(this.angle) < 45.0f || Math.abs(this.angle) > 315.0f;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption != null) {
            Direction.Axis axis = ((Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k();
            Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            Vec3d vec = new Vec3d(1.0, 1.0, 1.0).func_186678_a((double)this.angle).func_216369_h(new Vec3d(direction.func_176730_m()));
            this.movedContraption.rotateTo(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
    }

    @Override
    public void attach(ContraptionEntity contraption) {
        BlockState blockState = this.func_195044_w();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!blockState.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            return;
        }
        this.movedContraption = contraption;
        this.func_70296_d();
        BlockPos anchor = this.field_174879_c.func_177972_a((Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
        this.movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        if (!this.field_145850_b.field_72995_K) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> {
            Direction.Axis axis = d.func_176740_k();
            Direction.Axis bearingAxis = ((Direction)state.func_177229_b((IProperty)MechanicalBearingBlock.FACING)).func_176740_k();
            return bearingAxis != axis;
        });
    }

    @Override
    public void collided() {
    }

    @Override
    public boolean isAttachedTo(ContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }
}

