/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.mixer;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.IItemHandler;

public class MechanicalMixerTileEntity
extends BasinOperatingTileEntity {
    private static Object shapelessOrMixingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;
    public ScrollValueBehaviour minIngredients;

    public MechanicalMixerTileEntity(TileEntityType<? extends MechanicalMixerTileEntity> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((state, direction) -> direction.func_176740_k().func_176722_c()){

            @Override
            protected Vec3d getSouthLocation() {
                return super.getSouthLocation().func_72441_c(0.0, 0.25, 0.0);
            }
        };
        this.minIngredients = new ScrollValueBehaviour(Lang.translate("mechanical_mixer.min_ingredients", new Object[0]), this, slot);
        this.minIngredients.between(1, 9);
        this.minIngredients.withCallback(i -> this.basinChecker.scheduleUpdate());
        this.minIngredients.requiresWrench();
        behaviours.add(this.minIngredients);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        int localTick = 0;
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - MathHelper.func_76134_b((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else if (this.runningTicks > 20) {
                localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - MathHelper.func_76134_b((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.running) {
            if (this.runningTicks < 15) {
                return speed;
            }
            if (this.runningTicks <= 20) {
                return speed * 2.0f;
            }
            if (this.runningTicks > 20) {
                return speed;
            }
        }
        return speed / 2.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(0.0, -1.5, 0.0);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.running = compound.func_74767_n("Running");
        this.runningTicks = compound.func_74762_e("Ticks");
        super.func_145839_a(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("Running", this.running);
        compound.func_74768_a("Ticks", this.runningTicks);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running) {
            if (this.field_145850_b.field_72995_K && this.runningTicks == 20) {
                this.renderParticles();
            }
            if (!this.field_145850_b.field_72995_K && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    this.processingTicks = MathHelper.func_76125_a((int)(MathHelper.func_151239_c((int)((int)(512.0f / speed))) * 15 + 1), (int)1, (int)512);
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    public void renderParticles() {
        IItemHandler itemHandler = (IItemHandler)this.basinInv.orElse(null);
        if (itemHandler != null) {
            BasinTileEntity.BasinInventory inv = (BasinTileEntity.BasinInventory)itemHandler;
            for (int slot = 0; slot < inv.getInputHandler().getSlots(); ++slot) {
                ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
                if (stackInSlot.func_190926_b()) continue;
                ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, stackInSlot);
                float angle = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
                Vec3d offset = new Vec3d(0.0, 0.0, 0.25);
                offset = VecHelper.rotate(offset, angle, Direction.Axis.Y);
                Vec3d target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, Direction.Axis.Y).func_72441_c(0.0, 0.25, 0.0);
                Vec3d center = offset.func_178787_e(VecHelper.getCenterOf((Vec3i)this.field_174879_c));
                target = VecHelper.offsetRandomly(target.func_178788_d(offset), this.field_145850_b.field_73012_v, 0.0078125f);
                this.field_145850_b.func_195594_a((IParticleData)data, center.field_72450_a, center.field_72448_b - 2.0, center.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c);
            }
        }
    }

    @Override
    protected <C extends IInventory> boolean matchStaticFilters(IRecipe<C> r) {
        return (r.func_199559_b() == IRecipeSerializer.field_222158_b || r.func_222127_g() == AllRecipeTypes.MIXING.type) && !MechanicalPressTileEntity.canCompress((NonNullList<Ingredient>)r.func_192400_c());
    }

    @Override
    protected <C extends IInventory> boolean matchBasinRecipe(IRecipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        if (recipe.func_192400_c().size() < this.minIngredients.getValue()) {
            return false;
        }
        NonNullList ingredients = recipe.func_192400_c();
        if (!ingredients.stream().allMatch(ingredient -> ingredient.isSimple() || ingredient.func_193365_a().length == 1)) {
            return false;
        }
        ArrayList remaining = new ArrayList();
        this.inputs.forEach(stack -> remaining.add(stack.func_77946_l()));
        LinkedList sortedIngredients = new LinkedList(ingredients);
        sortedIngredients.sort((i1, i2) -> i1.func_193365_a().length - i2.func_193365_a().length);
        block0: for (Ingredient ingredient2 : sortedIngredients) {
            for (ItemStack stack2 : remaining) {
                if (stack2.func_190926_b() || !ingredient2.test(stack2)) continue;
                stack2.func_190918_g(1);
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    @Override
    protected void basinRemoved() {
        super.basinRemoved();
        if (this.running) {
            this.runningTicks = 40;
            this.running = false;
        }
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }
}

